function [tth, counts]=GIX_readDat(fileName,binby)
%[tth, counts]=GIX_readDat(fileName,binby)
% Read a .dat file which is formatted as below.
% binby >= 1 (int) adds counts across 'binby' bins
%  &SRS
%  SRSRUN=364288,SRSDAT=2015125,SRSTIM=214819,
%  SRSSTN='i11 ',SRSPRJ='HRPD    ',SRSEXP='MAC     ',
%  SRSTLE='                                                            ',
%  SRSCN1='        ',SRSCN2='        ',SRSCN3='        ',
%  &END
% tth	mac15
% 16.3000208	143
% 16.8000041	113
[num_lines]=fileLines(fileName);
fid = fopen(fileName);
if fid < 1
    error(['couldn''t open file ' fileName]);
end

tline = fgets(fid);
header = 0;
lineCount = 0;
while ischar(tline)
    tline = fgetl(fid);
    lineCount = lineCount + 1;
    % find header
    %     if header > 1
    %         if tline~=-1
    %             % read line in
    %             s = sscanf(tline,'%f %f');
    %             if length(s)==2
    %                 result(header-1,:) = s;
    %                 header = header+1;
    %             elseif length(s)==3
    %                 result(header-1,:) = s(1:2);
    %                 header = header+1;
    %             end
    %         end
    %     else
    if header == 0
        if strncmp(tline,'tth',3)
            header = 1;
            result = zeros(num_lines-lineCount,2);
            headerPos = ftell(fid);
            break
        end
    elseif header == 1
        header = 2;
    end
end
try
    % two column
    fseek(fid,headerPos,'bof');
    C=textscan(fid,'%f %f');
    if sum(cell2mat(cellfun(@isnan,B(:),'uni',0)))
        error('nan found');
    end
catch 
    % three column
    fseek(fid,headerPos,'bof');
    C=textscan(fid,'%f %f %f');
end
fclose(fid);
% tth = result(:,1);
% counts = result(:,2);
tth = C{1};
counts = C{2};

% binning
q=1;p=binby;

M=[tth counts]; % only two columns
[m,n]=size(M); %M is the original matrix

% crop data so that it will bin nicely
% drop data from the end of the file
remainder = mod(m,binby);
M = M(1:(end-remainder),:);
[m,n]=size(M); %M is the original matrix

% reshaping and summing
M=sum( reshape(M,p,[]) ,1 );
M=reshape(M,m/p,[]).'; %Note transpose

M=sum( reshape(M,q,[]) ,1);
M=reshape(M,n/q,[]).'; %Note transpose

tth = M(:,1)/binby;
counts = M(:,2);

end