% GIX shift fix
% import xye files
root = 'C:\Users\andy\Documents\DIAMOND-AJL\';
% peak finding
mindist = 200;
pkheight = 150;
thres = 0.04; % threshold of twotheta in percentage, eg 21.0 and 20.0 => thres = 0.05
hkl=[4:2:26 30:2:44]';
a=2.87174; % a-value in A
lambda = 0.8256502; % x-ray wavelength
d=a./sqrt(hkl);
ttc = asind(lambda./(2.*d))*2; % theoretical 2theta
files = dir(strcat(root,'*.xye'));
C={files.name}';
num_files = length(C);
% for storing the results:
fitted = zeros(num_files,3); % a-param, gradient, intercept of theoretical twotheta and calculated tt
for i=1:num_files
    % import
    [tt,y]=GIX_import(strcat(root,C{i}));
    % find the alpha-iron peaks
    [pks,locs] = findpeaks(y,'MINPEAKHEIGHT',pkheight,'sortstr','none','MINPEAKDISTANCE',mindist);
    % correct the twotheta shift
    ttcPos = ttc.*0;
    ttP = tt(locs); % tt locations of the peaks
    for p=1:length(ttc) % search thoretical values
        pos = find(ttP>ttc(p)*(1-thres) & ttP<ttc(p)*(1+thres));
        if length(pos)==1
            % asign position
            ttcPos(p) = pos;
        elseif length(pos)>1
            disp('multiple fit found, reduce threshold for fitting');
            ttcPos(p) = nan;
        else
            ttcPos(p) = nan;
        end
    end
    % refine a
    % expr d-spacings:
    tte = ttP(ttcPos(~isnan(ttcPos)));
    d_exp = lambda./(2*sind( tte/2 ));
    f = (cosd((tte/2))).^2; % cos2
    measured_a = d_exp.*sqrt(hkl(~isnan(ttcPos)));
    % find intercept and gradient of cos2theta function v d
    fob1 = fit(f,measured_a,'poly1','Robust', 'LAR' );
    disp(strcat('Grad:',num2str(fob1.p1),' inter:',num2str(fob1.p2)));
    fitted(i,1) = fob1.p2; % store lattic parameter
    h=figure; % new figure to plot calibration info
    plot(f,measured_a,0:.1:1,fob1(0:.1:1),'r-');
    annotation('textbox', [.2 .8, .1, .1], 'String', num2str(fob1.p2,6));
    xlabel('cos^2\theta');title(num2str(i));
    ylabel('a ()');
    saveas(h,regexprep(strcat(root,C{i}),'.xye','-f.png'));
    close(h); % close figure window
    a1 = fob1.p2; % new estimate for lattice spacing
    [ttc]=twotheta(a1,lambda,hkl); % new theoretical 2theta values
    % find intercept and gradient
    fob = fit(ttc(~isnan(ttcPos)),ttP(ttcPos(~isnan(ttcPos))),'poly1');
    disp(strcat('Grad:',num2str(fob.p1),' inter:',num2str(fob.p2)));
    % store results
    fitted(i,2) = fob.p1;
    fitted(i,3) = fob.p2;
    % apply offset to original
    tt = tt+fob.p2;
    pause
    % write out file
    csvwrite(regexprep(strcat(root,C{i}),'.xye','-B.csv'),[tt y]);
    %disp(strcat('Wrote:',regexprep(strcat(root,C{i}),'.xye','-B.csv')));
end
