% GIX peak scan data reading
% Data is grouped using sub-folders in this base directory:
froot = 'C:\Users\andy\Documents\EE10185-1\';
% specify which folders the .dat files are in which contain the data
folders = strcat({'C','C05','C0510', 'C05H','B2','B3'},'_peakScan');
scaleFactor = {1,1,1,1,2,2}; % divide the counts in each folder by this amount
% load the incident angles used from a simple txt document, angles stored
% as a row list of doubles 'angles.txt'
angles = cell(length(folders),1);
for f=1:length(folders)
    angles{f} = load([froot folders{f} '\angles.txt']);
end

folders = strcat(froot, folders,'\');
output = cell(length(folders),1);
for f=1:length(folders)
    root = folders{f};
    files = dir(strcat(root,'*.dat'));
    C={files.name}';
    num_files = length(C);
    if num_files ~= length(angles{f})
        error([num2str(num_files) ' files, but ' num2str(length(angles{f})) ' specified angles in' froot folders{f} 'angles.txt']);
    end
    result = zeros(num_files,3);
    result(:,1) = angles{f};
    for i=1:num_files
        [a,b]=GIX_readDat([root C{i}],1);
        [~,ia]=sort(a);
        result(i,2:3) = b(ia)./scaleFactor{f};
    end
    % back ground correction
    bgfit = fit(result(:,1),result(:,3),'poly1');
    % save output in format:
    % incident angle, peak counts, bg counts, bg-corrected counts, material code
    output{f} = num2cell([result(:,1) result(:,2) result(:,3) result(:,2)-bgfit(result(:,1))]);
    output{f}(:,end+1) = {regexprep(regexprep(folders{f},regexprep(froot,'\\','\\\'),''),'_peakScan\','')};
end
% save output as csv file:
outputData = [{'angle','peak','bg','corPeak' 'mat'}; vertcat(output{:})];
cell2csv('GIXpeakScans.csv',outputData);