% Fit a model function to a peak in XRD data
% Integrate the signal between a set of points

% old
% root = 'C:\Users\andy\Documents\DIAMOND-AJL\';
% files = dir(strcat(root,'*.xye'));
% C={files.name}';

% new
[d,cols]=GIXdataBase('time>60',0);
d=d(strcmp(d(:,4),'FeCrTiY')|strcmp(d(:,4),'FeTiY'),:);
C = d(:,strcmp(cols,'file'));
%plotBetween = [15.5 17]; % n-rows, 2-columns
plotBetween = [14.75 17.3]; % n-rows, 2-columns
sumBetween = [16 16.5];
peakPosition = 16.263725063697308; % known peak position

num_files = length(C);
% for storing the results:
px = cell(num_files,1);
py = cell(num_files,1);
pyprime = cell(num_files,1);
p = zeros(num_files,5);
ci = cell(num_files,1);
intSignal = zeros(num_files,1);
for i=1:num_files
    % import
    [tt,y]=GIX_import(C{i});
    px{i} = tt(tt > plotBetween(1) & tt < plotBetween(2));
    py{i} = y(tt > plotBetween(1) & tt < plotBetween(2));
    % p(3L) = [Amplitude Centre Width Constant Linear]
    [pyprime{i}, p(i,:),~,~,ci{i}] = lorentzfit(px{i}-peakPosition,py{i},[3 0 0.02 min(py{i}) 0],[0 -0.1 0.006 -Inf -Inf; Inf 0.1 0.07 Inf Inf],'3l');
    % integrate fit
    %intSignal(i) = sum(p(i,1)./((px{i}-peakPosition).^2 + p(i,2)));
    %backgroundCorrected = py{i}-(p(i,3)*px{i}+p(i,4));
    backgroundCorrected = py{i}-p(i,4)+p(i,5)*(px{i}-peakPosition);
    intSignal(i) = sum(backgroundCorrected(px{i}<sumBetween(2) & px{i}>sumBetween(1)));
    %figure
    %plot(px{i},py{i},'k-',px{i},pyprime{i},'r-',px{i},p(i,4)+p(i,5)*(px{i}-peakPosition),'g-');
    %title(C{i});
end
s = d(:,strcmp(cols,'matCode')); %s=cellfun(@(x) x(1:2),C,'uni',0); % Cr, CL etc
%a = cell2mat(cellfun(@(x) str2double(x(4:6)),C,'uni',0))/100; % incident angle
a = d(:,strcmp(cols,'tilt'));
attnLn = d(:,strcmp(cols,'attnLength'));

ci2 = vertcat(ci{:});
errorsL = reshape(ci2(:,1),5,[])';
errorsU = reshape(ci2(:,2),5,[])';
errorsL(errorsL(:,3)<0,3) = 0; % limit to 0
errorsU(errorsU(:,3)<0,3) = 0; % limit to 0
errorsL(:,6) = 2*sqrt(errorsL(:,3));
errorsU(:,6) = 2*sqrt(errorsU(:,3));
w2 = 2*sqrt(p(:,3)); % actual FWHM
% normalise by total time:
p(:,1) = 3600*p(:,1)./cell2mat(d(:,strcmp(cols,'time')));
errorsL(:,1) = errorsL(:,1)*3600./cell2mat(d(:,strcmp(cols,'time')));
errorsU(:,1) = errorsU(:,1)*3600./cell2mat(d(:,strcmp(cols,'time')));
intSignal = 3600*intSignal./cell2mat(d(:,strcmp(cols,'time')));

%export data:
exportData = [{'Sample'} cols(4:8) {'Angle','AttnLength',...
    'Amp','Centre','Width','w2',...
    'AmpL','CentreL','WidthL','w2L',...
    'AmpU','CentreU','WidthU','w2U',...
    'Integrated'}; ...
    s d(:,4:8) a attnLn num2cell(p(:,1:3)) num2cell(w2) num2cell([errorsL(:,[1:3 6]) errorsU(:,[1:3 6])]) num2cell(intSignal)];
cell2csv('GIX_2015.csv',exportData);