% Fit a model function to a peak in XRD data
% Integrate the signal between a set of points

[d,cols]=GIXdataBase('time>60');
d = d(5:23,:);
C = d(:,strcmp('file',cols));
times = cell2mat(d(:,strcmp('time',cols))); % normalise aquistion time
times = times./min(times);

plotBetween = [20 27]; % 2-columns
fitBetween = [20 27]; % 2-columns
exportBetween = [20 27];

sumBetween = [22 25];
peakPosition = 23.45; % known peak position
maxResidual = 2; % maximum distance from first fitting of the background 
% in standard deviations, 1 = one standard deviation
window = 0.2; % remove peak window in twotheta degrees
ignore = [15.75 17]; % manual peak removal

num_files = length(C);
% for storing the results:
maxy = cell(num_files,1);
px = cell(num_files,1);
py = cell(num_files,1);
pfx = cell(num_files,1);
pfy = cell(num_files,1);
pyprime = cell(num_files,1);
pBg = cell(num_files,1);
p = zeros(num_files,4);
intSignal = zeros(num_files,1);

for i=1:num_files
    % import
    [tt,y]=GIX_import(C{i});
    y = y/times(i);
    wwidth = window/(tt(3)-tt(2));
    px{i} = tt(tt > plotBetween(1) & tt < plotBetween(2));
    py{i} = y(tt > plotBetween(1) & tt < plotBetween(2));
    pfx{i} = tt(tt > fitBetween(1) & tt < fitBetween(2));
    pfy{i} = y(tt > fitBetween(1) & tt < fitBetween(2));
    maxy{i} = max(py{i});
    pfy{i} = pfy{i}./maxy{i}; % normalise
    py{i} = py{i}./maxy{i}; % normalise
    
    %py{i} = py{i}-min(py{i});
    %pfy{i} = pfy{i}-min(pfy{i});
    
    [xData, yData] = prepareCurveData( px{i}, py{i} );
    for j=0:0
        if 0
    % background fitting
    
    
    % Set up fittype and options.
    ft = fittype( 'poly2' );
    opts = fitoptions( ft );
    opts.Lower = [-Inf -Inf -Inf];
    opts.Robust = 'Bisquare';
    opts.Upper = [Inf Inf Inf];
    
    % Fit model to data. First
    [fitresult, gof] = fit( xData, yData, ft, opts );
    
    % Remove outliers
    residual = yData-fitresult(xData);
    sd = std(residual)*maxResidual;
    
    % Re-fit after removing peaks: using window around outliers method
    r = residual>-sd & residual<sd;
    r = bwmorph(~r,'dilate',wwidth);
    r = r | (xData>ignore(1) & xData<ignore(2));
    xData = xData(~r);
    yData = yData(~r);
    
    % Fit model to data. Second
    [fitresult, gof] = fit( xData, yData, ft, opts );
        end
    end
    %figure

    [pyprime{i}, p(i,:)] = lorentzfit(pfx{i}-peakPosition,pfy{i},[0.001 0.07 0.006 0.01],[0 -Inf 0 0; Inf Inf Inf 1],'3c');
    % integrate fit
    %intSignal(i) = sum(p(i,1)./((px{i}-peakPosition).^2 + p(i,2)));
    %backgroundCorrected = py{i}-(p(i,3)*px{i}+p(i,4));
    %backgroundCorrected = py{i}-p(i,4)+p(i,3)*(px{i}-peakPosition);
    backgroundCorrected = py{i};
    intSignal(i) = sum(backgroundCorrected(px{i}<sumBetween(2) & px{i}>sumBetween(1)));
    figure
    
    semilogy(px{i},py{i},'k.',xData,yData,'rx',pfx{i},pyprime{i},'k-');
    %pBg{i} = fitresult(pfx{i});
    %plot(px{i},py{i},'k-',px{i},pyprime{i},'r-',px{i},p(i,4)+p(i,3)*(px{i}-peakPosition),'g-');
    title(C{i});
    %ylim([100 450])
end
s=cellfun(@(x) x(1:2),C,'uni',0); % Cr, CL etc
a = cell2mat(cellfun(@(x) str2double(x(4:6)),C,'uni',0))/100; % incident angle
% %export data:
% exportData = [{'Sample','Angle','Amp','Width','Integrated'}; s num2cell(a) num2cell(p(:,1:2)) num2cell(intSignal)];
% % export fitted curves
% exportCurves = [vertcat(pfx{:}) vertcat(pfy{:}) vertcat(pyprime{:})+vertcat(pBg{:}) vertcat(pBg{:}) ];
lambda = 0.8256502; % x-ray wavelength
subplot(1,2,1);
plot(cell2mat(d(1:8,13)),sqrt(2)*lambda./(2*sind(  (p(1:8,2)+peakPosition)/2 )),'o-',cell2mat(d(9:end,13)),sqrt(2)*lambda./(2*sind(  (p(9:end,2)+peakPosition)/2 )),'x-')
xlabel('Attenuation depth /nm');ylabel('d-spacing /Ang')
legend('Irrd. 120 K','As-Rec.')
subplot(1,2,2);
plot(cell2mat(d(1:8,13)),p(1:8,3),'o-',cell2mat(d(9:end,13)),p(9:end,3),'x-')
xlabel('Attenuation depth /nm');ylabel('peak width two \theta')
legend('Irrd. 120 K','As-Rec.')