% Fit a model function to a peak in XRD data
% Integrate the signal between a set of points

[d,cols]=GIXdataBase('time>60');
d = d([1 3 6 19],:);
C = d(:,strcmp('file',cols));
times = cell2mat(d(:,strcmp('time',cols))); % normalise aquistion time
times = times./min(times);

plotBetween = [12 20]; % 2-columns
fitBetween = [15 17]; % 2-columns
exportBetween = [15.5 17];

sumBetween = [16 16.5];
peakPosition = 16.263725063697308; % known peak position
maxResidual = 2; % maximum distance from first fitting of the background 
% in standard deviations, 1 = one standard deviation
window = 0.2; % remove peak window in twotheta degrees
ignore = [15.75 17]; % manual peak removal

num_files = length(C);
% for storing the results:
px = cell(num_files,1);
py = cell(num_files,1);
pfx = cell(num_files,1);
pfy = cell(num_files,1);
pyprime = cell(num_files,1);
pBg = cell(num_files,1);
p = zeros(num_files,2);
intSignal = zeros(num_files,1);

for i=1:num_files
    % import
    [tt,y]=GIX_import(C{i});
    y = y/times(i);
    wwidth = window/(tt(3)-tt(2));
    px{i} = tt(tt > plotBetween(1) & tt < plotBetween(2));
    py{i} = y(tt > plotBetween(1) & tt < plotBetween(2));
    pfx{i} = tt(tt > fitBetween(1) & tt < fitBetween(2));
    pfy{i} = y(tt > fitBetween(1) & tt < fitBetween(2));
    
    % background fitting
    [xData, yData] = prepareCurveData( px{i}, py{i} );
    
    % Set up fittype and options.
    ft = fittype( 'poly2' );
    opts = fitoptions( ft );
    opts.Lower = [-Inf -Inf -Inf];
    opts.Robust = 'Bisquare';
    opts.Upper = [Inf Inf Inf];
    
    % Fit model to data. First
    [fitresult, gof] = fit( xData, yData, ft, opts );
    
    % Remove outliers
    residual = yData-fitresult(xData);
    sd = std(residual)*maxResidual;
    
    % Re-fit after removing peaks: using window around outliers method
    r = residual>-sd & residual<sd;
    r = bwmorph(~r,'dilate',wwidth);
    r = r | (xData>ignore(1) & xData<ignore(2));
    xData = xData(~r);
    yData = yData(~r);
    
    % Fit model to data. Second
    [fitresult, gof] = fit( xData, yData, ft, opts );
    
    %figure

    [pyprime{i}, p(i,:)] = lorentzfit(pfx{i}-peakPosition,pfy{i}-fitresult(pfx{i}),[3 0.02],[0 0.006; Inf 0.1],'2');
    % integrate fit
    %intSignal(i) = sum(p(i,1)./((px{i}-peakPosition).^2 + p(i,2)));
    %backgroundCorrected = py{i}-(p(i,3)*px{i}+p(i,4));
    %backgroundCorrected = py{i}-p(i,4)+p(i,3)*(px{i}-peakPosition);
    backgroundCorrected = py{i}-fitresult(px{i});
    intSignal(i) = sum(backgroundCorrected(px{i}<sumBetween(2) & px{i}>sumBetween(1)));
    %figure
    subplot(2,2,i);
    plot(px{i},py{i},'k.',px{i},fitresult(px{i}),xData,yData,'rx',pfx{i},pyprime{i}+fitresult(pfx{i}),'k-');
    pBg{i} = fitresult(pfx{i});
    %plot(px{i},py{i},'k-',px{i},pyprime{i},'r-',px{i},p(i,4)+p(i,3)*(px{i}-peakPosition),'g-');
    title(C{i});
    ylim([100 450])
end
s=cellfun(@(x) x(1:2),C,'uni',0); % Cr, CL etc
a = cell2mat(cellfun(@(x) str2double(x(4:6)),C,'uni',0))/100; % incident angle
%export data:
exportData = [{'Sample','Angle','Amp','Width','Integrated'}; s num2cell(a) num2cell(p(:,1:2)) num2cell(intSignal)];
% export fitted curves
exportCurves = [vertcat(pfx{:}) vertcat(pfy{:}) vertcat(pyprime{:})+vertcat(pBg{:}) vertcat(pBg{:}) ];