% Fit a model function to a peak in XRD data
% Integrate the signal between a set of points
root = 'C:\Users\andy\Documents\DIAMOND-AJL\';
plotBetween = [15.5 17]; % n-rows, 2-columns
sumBetween = [16 16.5];
peakPosition = 16.263725063697308; % known peak position
files = dir(strcat(root,'*.xye'));
C={files.name}';
num_files = length(C);
% for storing the results:
px = cell(num_files,1);
py = cell(num_files,1);
pyprime = cell(num_files,1);
p = zeros(num_files,4);
intSignal = zeros(num_files,1);
for i=1:num_files
    % import
    [tt,y]=GIX_import(strcat(root,C{i}));
    px{i} = tt(tt > plotBetween(1) & tt < plotBetween(2));
    py{i} = y(tt > plotBetween(1) & tt < plotBetween(2));
    [pyprime{i}, p(i,:)] = lorentzfit(px{i}-peakPosition,py{i},[3 0.02 0 min(py{i})],[0 0.006 -Inf -Inf; Inf 0.1 Inf Inf],'2l');
    % integrate fit
    %intSignal(i) = sum(p(i,1)./((px{i}-peakPosition).^2 + p(i,2)));
    %backgroundCorrected = py{i}-(p(i,3)*px{i}+p(i,4));
    backgroundCorrected = py{i}-p(i,4)+p(i,3)*(px{i}-peakPosition);
    intSignal(i) = sum(backgroundCorrected(px{i}<sumBetween(2) & px{i}>sumBetween(1)));
    figure
    plot(px{i},py{i},'k-',px{i},pyprime{i},'r-',px{i},p(i,4)+p(i,3)*(px{i}-peakPosition),'g-');
    title(C{i});
end
s=cellfun(@(x) x(1:2),C,'uni',0); % Cr, CL etc
a = cell2mat(cellfun(@(x) str2double(x(4:6)),C,'uni',0))/100; % incident angle
%export data:
exportData = [{'Sample','Angle','Amp','Width','Integrated'}; s num2cell(a) num2cell(p(:,1:2)) num2cell(intSignal)];