function [tt,y] = GIX_import(filename, startRow, endRow)
%IMPORTFILE Import numeric data from a text file as column vectors.
%   [TT,Y] = IMPORTFILE(FILENAME) Reads data from text file xye for
%   the default selection.
%
%   [TT,Y] = IMPORTFILE(FILENAME, STARTROW, ENDROW) Reads data from rows
%   STARTROW through ENDROW of text file FILENAME.
%
% Example:
%   [tt,y] = importfile('C2_400.xye',1, 7501);
%
%    See also TEXTSCAN.

% Auto-generated by MATLAB on 2014/06/14 11:43:07

%% Initialize variables.
if nargin<=2
    startRow = 1;
    endRow = Inf;
end

%% Format string for each line of text:
%   column1: double (%f)
%	column2: double (%f)
% For more information, see the TEXTSCAN documentation.
formatSpec = '%16f%16f%[^\n\r]';

%% Open the text file.
fileID = fopen(filename,'r');

%% Read columns of data according to format string.
% This call is based on the structure of the file used to generate this
% code. If an error occurs for a different file, try regenerating the code
% from the Import Tool.
dataArray = textscan(fileID, formatSpec, endRow(1)-startRow(1)+1, 'Delimiter', '', 'WhiteSpace', '', 'EmptyValue' ,NaN,'HeaderLines', startRow(1)-1, 'ReturnOnError', false);
for block=2:length(startRow)
    frewind(fileID);
    dataArrayBlock = textscan(fileID, formatSpec, endRow(block)-startRow(block)+1, 'Delimiter', '', 'WhiteSpace', '', 'EmptyValue' ,NaN,'HeaderLines', startRow(block)-1, 'ReturnOnError', false);
    for col=1:length(dataArray)
        dataArray{col} = [dataArray{col};dataArrayBlock{col}];
    end
end

%% Close the text file.
fclose(fileID);

%% Allocate imported array to column variable names
tt = dataArray{:, 1};
y = dataArray{:, 2};

