% GIX matrix peak fitting

% import xye files
[d,cols]=GIXdataBase('time>60',0);
%d=d(strcmp(d(:,4),'FeCrTiY')|strcmp(d(:,4),'FeTiY'),:);
d=d(strcmp(d(:,2),'CL'),:); % select C010 samples
C = d(:,strcmp(cols,'file'));
num_files = length(C);

% peak finding
mintt = 20; % minimum twotheta
maxtt = 149; % maximum twotheta
mindist = 220;
pkheight = 150;
thres = 0.025; % threshold of twotheta in percentage, eg 21.0 and 20.0 => thres = 0.05
hkl=[2:2:26 30:2:44]';
HKL=[110;200;211;220;310;222;321;400;330;420;332;422;510;521;440;433;600;532;620;541;622;];
a=2.87174; % a-value in A
lambda = 0.8256502; % x-ray wavelength in A
d=a./sqrt(hkl);
ttc = asind(lambda./(2.*d))*2; % theoretical 2theta

% for storing the results:
fitted = cell(num_files,1);
poses = zeros(num_files,length(hkl));
%zeros(num_files,3); % a-param, gradient, intercept of theoretical twotheta and calculated tt
for i=1:num_files
    % import
    [tt,y]=GIX_import(C{i});
    y = y(tt>mintt& tt<maxtt); % set min and max two theta
    tt = tt(tt>mintt & tt<maxtt); 
    
    % find the alpha-iron peaks
    [pks,locs] = findpeaks(y,'MINPEAKHEIGHT',pkheight,'sortstr','none','MINPEAKDISTANCE',mindist);
    % correct the twotheta shift
    ttcPos = ttc.*0;
    ttP = tt(locs); % tt locations of the peaks
    for p=1:length(ttc) % search thoretical values
        pos = find(ttP>ttc(p)*(1-thres) & ttP<ttc(p)*(1+thres));
        if length(pos)==1
            % asign position
            ttcPos(p) = pos;
        elseif length(pos)>1
            disp('multiple fit found, reduce threshold for fitting');
            ttcPos(p) = nan;
        else
            ttcPos(p) = nan;
        end
    end
    % peak positions in two theta: tte
    tte = ttP(ttcPos(~isnan(ttcPos)));
    foundPks = pks(ttcPos(~isnan(ttcPos)));
    foundLocs = locs(ttcPos(~isnan(ttcPos)));
%     semilogy(tt,y,tte,pks(ttcPos(~isnan(ttcPos))),'r^');
%     title(C{i});
    %pause
    % find area for peak fitting
    windows = zeros(length(tte),2);
    % 0 -> 1st peak
    [~,windows(1,1)] = min(y(1:foundLocs(1)));
    % 1st -> 2nd ... -> last peak
    for p=2:length(tte)
        [~,j] = min(y(foundLocs(p-1):foundLocs(p)));
        windows(p-1,2) = foundLocs(p-1)+j-1;
        windows(p,1) = foundLocs(p-1)+j-1;
        %[~,j] = min(y(foundLocs(p):foundLocs(p+1)));
        %windows(p,1) = foundLocs(p)+j-1;
    end
    % last peak -> end
    [~,j] = min(y(foundLocs(end):end));
    windows(end,2) = foundLocs(end)+j-1;

    % peak fitting
    fit1 = cell(length(tte),1);
    for p=1:length(tte)
        ii = windows(p,1):windows(p,2);
        fit1{p} = GIX_fitApeak(tt(ii),y(ii));
    end
    fitted{i} = fit1;
    poses(i,:) = cell2mat(cellfun(@(x) x{2}(2),fit1,'uni',0)');
end
d_exp = lambda./(2.*sind( poses./2 )); % d-values

% W-H plot
wh = zeros(num_files,2);
for i =1:num_files
    xx = sind(poses(i,:)/2);
    yy = cell2mat(cellfun(@(x) x{3}(3),fitted{i},'uni',0)).*cosd(poses(i,:)'/2);
    xx = xx(~isnan(yy));
    yy = yy(~isnan(yy));
    lfit = fit(xx',yy,'poly1','Robust', 'LAR' );
    figure
    plot(xx,yy,xx,lfit(xx))
    wh(i,:) = [lfit.p1 lfit.p2];
end