function fitresult = GIX_fitApeak(x,y)
%fitresult = GIX_fitApeak(x,y)
% returns the fitted results (y' values), the parameters

[ymax,peakPositionB] = max(y); % for normalising height
peakPosition = x(peakPositionB); % for centring

% p(3L) = [Amplitude Centre Width Constant Linear]
[pyprime, p,~,~,ci] = lorentzfit(x-peakPosition,y./ymax,[1 0 1 min(y) 0],[0 min(x-peakPosition) 0 -Inf -Inf; Inf max(x-peakPosition) Inf Inf Inf],'3l');
c = (p(4)-peakPosition*p(5))*ymax; % new bg constant
p = [p(1)*ymax p(2)+peakPosition p(3) c p(5)*ymax];

fitresult = {pyprime.*ymax,p};
% calc full width half maximum
markers = fwhm(x,fitresult{1}-x.*fitresult{2}(5)-fitresult{2}(4),0.5);
fitresult{3} = markers;
end