% grain boundary segregation from 1D line profiles exported from ivas
% Doesn't deal well with named/unknown ions! Due to ionic->atomic
% conversion
% Assumes the line profiel is along the Z direction
% target elements
targets = {'C','N','Y','Ti','O','Cr'};
atomsPerSqrNm = 19.1649625; % for number of monolayers
unitCell = 0.2866; % lattice parameter nm for counts/(a^2)

% fileList = {'R14_16469-v01.csv';'R14_17053-v01.csv';...
%     'R14_17178-v02a.csv';'R14_17178-v02b.csv';...
%     'R14_17985-v01.csv';'R14_19698-v01-1.csv';...
%     'R14_19698-v01-2.csv';'R14_19698-v01-3.csv';...
%     'R14_19698-v01-4.csv';'R14_19698-v01-5.csv';...
%     'R14_19704-v01.csv';'R14_20013-v01-0.csv';};
% fileList = strcat('C:\Users\andy\APT\GBs\',fileList);

fileList = {'C:\Users\andy\APT\GBs\R14_15576-v02.csv'};
%fileList = {'C:\Users\andy\APT\GBs\R14_15867-v02.csv'};
%fileList = {'C:\Users\andy\APT\R14_15576 YEx03\recons\recon-v02\default\R14_15576-v02-35nmDiameterCyclinder.csv'};
% fileList = {'C:\Users\andy\APT\GBs\R14_18890-v02-0.csv';...
%     'C:\Users\andy\APT\GBs\R14_18890-v02-1.csv';...
%     'C:\Users\andy\APT\GBs\R14_18890-v02-2.csv';...
%     'C:\Users\andy\APT\GBs\R14_18972-v01.csv';...
%     'C:\Users\andy\APT\GBs\R14_18516-v02-0.csv';...
%     'C:\Users\andy\APT\GBs\R14_18516-v02-1.csv';...
%     'C:\Users\andy\APT\GBs\R14_18516-v02-2.csv';...
%     'C:\Users\andy\APT\GBs\R14_18622-v02-0.csv';...
%     'C:\Users\andy\APT\GBs\R14_18622-v02-1.csv';...
%     'C:\Users\andy\APT\GBs\R14_18785-v01-0.csv';...
%     'C:\Users\andy\APT\GBs\R14_18785-v01-1.csv';...
%     'C:\Users\andy\APT\GBs\R14_18785-v01-2.csv';};

numFiles = length(fileList);
% results cells
dims = cell(numFiles,1);
A = cell(numFiles,1); % area nm^2
eles = cell(numFiles,1); % list of elements chosen
bulkDensity = cell(numFiles,1); % nm^-3
totalSeg = cell(numFiles,1);
segVol = cell(numFiles,1);
correctedSeg = cell(numFiles,1); % counts
arealDens = cell(numFiles,1); % areal density /nm2
monolayers = cell(numFiles,1); % /monlayers
perSqrA = cell(numFiles,1); % /a2 (unit cell size squrd)

for j = 1:numFiles
    % file
    f = fileList{j};
    disp(f);
    if isempty(dims{j})
        x = input('Type size x:')/2;
        y=x;
        %y = input('Type size y:')/2;
        %z = input('Type size z:');
        dims{j} = [x y];
    else
        x = dims{j}(1);
        y = dims{j}(2);
        %z = dims{j}(3);
    end
    % read headers
    fid=fopen(f);
    t=fgets(fid);
    headers = regexp(t,',','split');
    fclose(fid);
    ions = regexprep(headers(4:3+(length(headers)-3)/2),' %','');
    % read data
    n = csvread(f,1,0);
    dist = n(:,1);
    z = max(dist)-min(dist);
    ionCount = n(:,2);
    atomCount = n(:,3);
    percent = n(:,4:3+(length(headers)-3)/2); % first half of the data (ignoring dist and counts)
    err = n(:,4+(length(headers)-3)/2:end); % second half
    
    % possibly needs composing into atomic counts?
    % Doesn't deal well with named/unknown ions!
    [tab,ele]=ions2ionTable(ionStr2ions(ions));
    
    % is this atomic or ionic?
    nonEle = percent(:,~ismember(ions,ele));
    if sum(nonEle(:)) == 0
        % is atomic (only elemental ions)
        disp('Atomic');
        counts = percent.*repmat(atomCount,1,size(percent,2))./100;
        countSigma = err.*repmat(atomCount,1,size(percent,2))./100;
        counts = counts*tab;
    else
        % contains molecular ions
        disp('Ionic');
        countsI = percent.*repmat(ionCount,1,size(percent,2))./100;
        countISigma = err.*repmat(ionCount,1,size(percent,2))./100;
        counts = countsI*tab;
        countSigma = countISigma*tab;
    end
    
    % plot
    figure
    [m,loc]=ismember(ele,targets);
    legEnt = cell(1,sum(m));
    for i=1:sum(m)
        hold all
        plot(dist,counts(:,cumsum(m).*m==i));
        hold off
        legEnt{i} = ele{cumsum(m).*m==i};
    end
    legend(legEnt);
    xlabel('Dist. nm');
    ylabel('Counts');
    title(f);
    
    % save figure
    [pathstr, name, ext] = fileparts(f);
    saveas(gca,[pathstr '/' name '-plot'],'png');
    disp(['Saved:' pathstr '/' name '-plot.png']);
    
    % get "above" bound
    disp('Click on upper bound on graph (left of GB)');
    upLim = ginput(1);
    % get "lower" bound
    disp('Click on lower bound on graph (right of GB)');
    lowLim = ginput(1);
    
    % calculate results
    eles{j} = ele(m);
    tCounts = counts(:,m);
    A{j} = x*y*pi; % area nm^2
    % find "bulk" composition from min(dist) to upper bound
    bulkDensity{j} = sum(tCounts(dist<upLim(1),:),1)./(A{j}*upLim(1)); % nm^-3
    totalSeg{j} = sum(tCounts(dist>upLim(1) & dist<lowLim(1),:),1);
    segVol{j} = A{j}*(lowLim(1)-upLim(1));
    correctedSeg{j} = totalSeg{j}-segVol{j}*bulkDensity{j}; % counts
    arealDens{j} = correctedSeg{j}./A{j};
    monolayers{j} = arealDens{j}./atomsPerSqrNm;
    perSqrA{j} = arealDens{j}.*(unitCell^2);
end

% compile results table with areal density /nm^2
results = cell(numFiles+1,length(targets)+1);
results(1,:) = [{'file'} targets]; % elements as headers
for i = 1:numFiles
    [pathstr, name, ext] = fileparts(fileList{i});
    results{i+1,1} = name;
    [~,loc]=ismember(eles{i},targets);
    results(i+1,loc+1) = num2cell(arealDens{i});
end