% using the results from particleFinder and imageJ (stored in imageJ with
% columns: ID, Area, X, Y, Major, Minor, Angle; correlate particle size
% measurements between EFTEM and Fresnel imaging.

imageData = csvread('ImagejResults.csv',1,0);

iScale = 1/2.996; % nm per pixel
eScale = sc(1); % nm per pixel
matchDist = 5; % match particles < this dist in nm

% match particles between the two data sets
% imageJ Fresnel imaging
ixy = imageData(:,3:4)*iScale; % positions
ri = sqrt(imageData(:,2)/pi)*iScale; % area -> radius
% EFTEM filtered results
fxy = result2(:,9:10)*eScale; % positions
rf = result2(:,16)*eScale; % radii

offset = [415 487]-[422 492];
ang = -0.015;
rot = [cos(ang) -sin(ang); sin(ang) cos(ang)];
ixy2 = [ixy(:,1)-offset(1) ixy(:,2)-offset(1)];
o = [480 577];%range(ixy2)/2;
ixy2 = ((ixy2-repmat(o,size(ixy2,1),1))*rot) + repmat(o,size(ixy2,1),1);

plot(ixy2(:,1),ixy2(:,2),'.',fxy(:,1),fxy(:,2),'.');

[IDX,D]=knnsearch(ixy2,fxy);

% match only D < 5 nm
matches = zeros(sum(D<matchDist),2);
hold on
for i = 1:length(IDX)
    if D(i)<matchDist
        plot([fxy(i,1); ixy2(IDX(i),1)],[fxy(i,2); ixy2(IDX(i),2)],'g-');
        matches(sum(D(1:i)<matchDist),:) = [rf(i) ri(IDX(i))];
    end
end
hold off
figure
plot(matches(:,1),matches(:,2),'x');
xlabel('EFTEM radius nm'); ylabel('Fresnel radius nm');
cell2csv('eftemVfresnel.csv',[{'eftem','fresnel'}; num2cell(matches)]);
