% remove vacuum from EFTEM images

% read file
[FileName,PathName,FilterIndex] = uigetfile('*.dm*','F:\TEM\oj2200\C2 liftout\130307\EFTEM\Region 6\','F:\TEM\oj2200\C2 liftout\130307\EFTEM\Region 6\');
[m, sx, units]=ReadDMFile([PathName FileName]);
mm = sum(m,3); % sum together for thresholding
mm =medfilt2(mm,[9 9]);
% find "zeros"
[lev,bw]=thresh_tool(mm);
% remove columns
% clean single pixels and expand area to remove by 10 pixels
bw2 = ( ~bwmorph(~bwmorph(bwmorph(bw,'clean'),'dilate'),'dilate',10) );
m2 = m.*repmat(bw2,[1 1 size(m,3)]);
clear m
% save data
writeBIN([PathName regexprep(FileName,'\.dm3','.bin')],m2);
%h5write([PathName regexprep(FileName,'\.dm3','.h5')],'dataset',m2);
%writeMRC(m2,sx,[PathName regexprep(FileName,'\.dm3','.mrc')]);
clear m2 mm