% from an eigen image to define the particles, extracted maps using MLLS
% create at Y:Ti plot.
% files list = {'eigen images h5','Element map1','Element map2',[eigen
% image number], [upper band pass], [lower band pass], [threshold level]}
files = {'F:\TEM\oj2200\20140615\B05\R5\bss_factors.h5',...
    'F:\TEM\oj2200\20140615\B05\R5\MLLS\Fit integral for TiO2(0-0180eV) (Edge).dm3',...
    'F:\TEM\oj2200\20140615\B05\R5\MLLS\Fit integral for Y2O3(0-0180eV) (Edge).dm3',4,20,10,0.201895764400295;...
    'F:\TEM\oj2200\20140312\B3\bulk2\bss_factors.h5',...
    'F:\TEM\oj2200\20140312\B3\bulk2\MLLS\Fit integral for TiO2(0-0180eV) (Edge).dm3',...
    'F:\TEM\oj2200\20140312\B3\bulk2\MLLS\Fit integral for Y2O3(0-0180eV) (Edge).dm3',4,10,3,0.498031635775698;...
    'F:\TEM\oj2200\20140615\C010\R6-bulk\bss_loadings.h5',...
    'F:\TEM\oj2200\20140615\C010\R6-bulk\MLLS\Fit integral for TiO2(0-0180eV) (Edge).dm3',...
    'F:\TEM\oj2200\20140615\C010\R6-bulk\MLLS\Fit integral for Y2O3(0-0180eV) (Edge).dm3',3,50,2,4.29674007094392;};
f=3;
% Y/Ti ratio from EFTEM
[data,sc,sc_units] = eftemH5(files{f,1});
a=data(:,:,files{f,4});
aa=sum(a,3);
aa =medfilt2(aa,[9 9]);
b = bpass(aa,1,files{f,5})-bpass(aa,1,files{f,6});imagesc(b)
lvl=files{f,7};
%[lvl,bw]=thresh_tool(b);
bw = b>lvl;
s = regionprops(bw,'centroid','BoundingBox','EquivDiameter','PixelList','PixelIdxList','Image','Orientation','Eccentricity','MajorAxisLength','MinorAxisLength');
[ti]=ReadDMFile(files{f,2});
[y]=ReadDMFile(files{f,3});
ti=ti';
y=y';
y=medfilt2(y,[5 5]);
ti=medfilt2(ti,[5 5]);
yres = zeros(size(s,1),1);
tires = zeros(size(s,1),1);
for i=1:size(s,1)
yres(i) = sum(y(s(i).PixelIdxList));
tires(i) = sum(ti(s(i).PixelIdxList));
end
yti = yres./tires;
r = cell2mat({s.EquivDiameter}');
xy = cell2mat({s.Centroid}');
plot(r*sc(1),yti,'x');ylim([-5 10]);xlabel('Particle radius nm'); ylabel('Y/Ti ratio (scaled)');
figure
sel = yti>-5 & yti<10;
scatter(xy(sel,1),-xy(sel,2),r(sel).*r(sel)*0.2,yti(sel),'filled');ylim([-1000 0]);xlim([0 1000]);
%control
rc = 5:200;
Yc = zeros(length(rc),1);
Tic = zeros(length(rc),1);
minsize = min(size(y));
for i=1:length(rc)
    p = ceil(rand(1)*(minsize-rc(i)));
    p = p:(p+rc(i));
    Yc(i) = sum(sum(y(p,p)));
    Tic(i) = sum(sum(ti(p,p)));
%     if Yc(i)/Tic(i) >1.9 && Yc(i)/Tic(i) <2.1
%         figure
%         subplot(1,2,1);imagesc(y(p,p));
%         subplot(1,2,2);imagesc(ti(p,p));
%     end
end
figure
plot(rc/2,Yc./Tic,'x');ylim([-5 10])