function [fitresult, gof,h] = shellFit(x, crConc)
%shellFit(x,crCounts)
% Fits 3 gaussians to the Cr-shell of a line profile

%  Auto-generated by MATLAB on 19-Aug-2013 14:03:37
%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( x, crConc );

% Set up fittype and options.
ft = fittype( 'gauss3' );
opts = fitoptions( ft );
opts.Display = 'Off';
opts.Lower =      [-Inf -Inf 0    -Inf    -Inf  0   -Inf     -Inf      0];
opts.StartPoint = [.39  40 4.5  .33     60  62  8e-05   50.5    49.5];
opts.Upper =      [Inf  Inf Inf  Inf     Inf Inf  Inf      Inf      Inf];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
figure( 'Name', 'Cr-Shell fit' );
h = plot( fitresult, xData, yData);
legend( h, 'crCounts vs. x', 'untitled fit 1', 'Location', 'NorthEast' );
% Label axes
xlabel( 'Dist' );
ylabel( 'Cr Counts' );
grid on
end