% radiiSelection custom plotter
% A tool for plotting various graphs from radiiSelection output
% this assumes you've just run radiiSelection
crBulk = 0.12;
for ri = 1:(length(rlist)-1)
    cc = rhist{ri};
    % plot
    subplot(2,4,ri+1)
    % solute conc
    plot(2*zs*x*rx(ri)./profilePoints, (cc(x,pp(4))+cc(x,pp(5))+cc(x,pp(6)))./sum(cc(x,:),2) );
    hold all
    % cr ions
    plot(2*zs*x*rx(ri)./profilePoints, cc(x,pp(2))./sum(cc(x,:),2));
    % cr corrected
    crcor = cc(x,pp(2))-(cc(x,pp(1))*crBulk);
    plot(2*zs*x*rx(ri)./profilePoints, crcor./sum([crcor cc(x,3:end)],2));
    ylim([0 0.5]);
    xlabel('Radius /nm')
    ylabel('Ionic Fraction');
    legend('Solute','Cr','Cr*')
    title(strcat(num2str(rlist(ri)),'--',num2str(rlist(ri+1))));
    hold off
end
subplot(2,4,1);hist(radii,rx);title('Size Dist');xlabel('Radius nm');ylabel('Counts')
xlim([0 4])