% radii selection
% add up the line profiles based on the Rgz (radii) list

cr = 1;
x=1:profilePoints;
% identify ions
if(cr)
    pions = {'Fe','Cr','CrO','YO','Y','TiO','O','FeO'};
else
    pions = {'Fe','C','C','YO','Y','TiO','O','FeO'}; %#ok<UNRCH>
end
pp = zeros(length(pions),1);
for i = 1:length(pions)
    pp(i) =  find(strcmp(ionq,pions(i))); % position of these ions in cols
end

rstep = 0.5;
rlist = 0.5:rstep:(3.5+rstep);
rx = rlist(1:end-1)+rstep/2; % bin centres
% setup results cell
rhist = cell(length(rx),1);%cell([size(ziprofile{1}) length(rx)]);
for ri = 1:(length(rlist)-1)
    rhist{ri} = zeros(size(ziprofile{1}));
    % loop through radius list and bin data from ri to ri+1
    for c = 1:count
        % loop over all clusters
        if radii(c)>=rlist(ri)
            if radii(c)<rlist(ri+1)
            % add to results
            %disp('test');
                rhist{ri} = rhist{ri}+ziprofile{c};
            end
        end
    end
    cc = rhist{ri};
    % plot
    subplot(2,4,ri+1)
    plot(2*zs*x*rx(ri)./profilePoints, (cc(x,pp(4))+cc(x,pp(5))+cc(x,pp(6)))./sum(cc(x,:),2) );
    hold all
    plot(2*zs*x*rx(ri)./profilePoints, cc(x,pp(3))./sum(cc(x,:),2));
    plot(2*zs*x*rx(ri)./profilePoints, cc(x,pp(end))./sum(cc(x,:),2));
    plot(2*zs*x*rx(ri)./profilePoints, cc(x,pp(2))./sum(cc(x,:),2));
    ylim([0 0.3]);
    xlabel('Radius /nm')
    ylabel('Ionic Fraction');
    legend('Solute','CrO','FeO','Cr')
    title(strcat(num2str(rlist(ri)),'--',num2str(rlist(ri+1))));
    hold off
end