% Plots solute, CrO and FeO profile plots
cr = 1;
excludeClusters = [0]; %#ok<NBRAK>
smallLimit = 500;
% identify ions
if(cr)
    pions = {'Fe','Cr','CrO','YO','Y','TiO','O','FeO'};
else
    pions = {'Fe','C','C','YO','Y','TiO','O','FeO'}; %#ok<UNRCH>
end
pp = zeros(length(pions),1);
for i = 1:length(pions)
    pp(i) =  find(strcmp(ionq,pions(i))); % position of these ions in cols
end
x=1:profilePoints; % from clusterProfilerIonic, default = 100
c2 = zeros(size(ziprofile{1}));
c3small = c2;
fitresult = cell(count,1);
% show one profile at a time
%figure
for j=1:count
    c1 = ziprofile{j};
    solute = c1(x,pp(4))+c1(x,pp(5))+c1(x,pp(6));
    
    csum = cumsum(solute);
    [csumq,ia,ic] = unique(csum);
    if length(csumq)>2
        centrePos = round(interp1(csumq,x(ia),csum(end)/2));
    else
        centrePos = profilePoints/2;
    end
    %centrePos = 50.5; % use this to turn off shifting
    % shift profile
    c1 = circshift(c1,[round(profilePoints/2-centrePos),0]);
    if centrePos>=(profilePoints/2)
        % set last values to 0
        ci(round(centrePos):end,:) = 0;
    else
        % set first values to 0
        ci(1:round(centrePos),:) = 0;
    end
    % running total with exclude list
    if ~sum(j==excludeClusters)
        c2 = c2 + c1;
        if sum(c1(:,pp(2)),1)<smallLimit
           % if the cluster is too small then add to small counts
            c3small = c3small + c1; 
            disp('added to small list');
        else
           % fit cr conc
           [fitresult{j},~,fitploth] = shellFit(x,c1(x,pp(2))./sum(c1(x,:),2));
           pause
           close
        end
    end
    
    if(0) % plot figure per cluster and pause?
        subplot(1,2,1);
        plot(x*radii(j)/profilePoints, (c1(x,pp(4))+c1(x,pp(5))+c1(x,pp(6)))./sum(c1(x,:),2) );
        hold all
        plot(x*radii(j)/profilePoints,c1(x,pp(3))./sum(c1(x,:),2));
        plot(x*radii(j)/profilePoints,c1(x,pp(end))./sum(c1(x,:),2));
        plot(x*radii(j)/profilePoints,c1(x,pp(2))./sum(c1(x,:),2));
        ylabel('Ionic Fraction');
        legend('Solute','CrO','FeO','Cr')
        title(strcat('Cluster:',num2str(j)));
        hold off
        subplot(1,2,2); % counts
        plot(x*radii(j)/profilePoints,c1(x,pp(1)),x*radii(j)/profilePoints,c1(x,pp(2)));
        legend('Fe','Cr');
        title('Counts');
        pause
    end
end
figure
plot(x, (c2(x,pp(4))+c2(x,pp(5))+c2(x,pp(6)))./sum(c2(x,:),2) );
hold all
plot(x,c2(x,pp(3))./sum(c2(x,:),2));
plot(x,c2(x,pp(end))./sum(c2(x,:),2));
plot(x,c2(x,pp(2))./sum(c2(x,:),2));
ylabel('Ionic Fraction');
legend('Solute','CrO','FeO','Cr')
title(cf); % from clusterProfilerIonic
hold off

figure
plot(x, (c3small(x,pp(4))+c3small(x,pp(5))+c3small(x,pp(6)))./sum(c3small(x,:),2) );
hold all
plot(x,c3small(x,pp(3))./sum(c3small(x,:),2));
plot(x,c3small(x,pp(end))./sum(c3small(x,:),2));
plot(x,c3small(x,pp(2))./sum(c3small(x,:),2));
ylabel('Ionic Fraction');
legend('Solute','CrO','FeO','Cr')
title(strcat(cf,':small')); % from clusterProfilerIonic
hold off