function [elements,countsDecomp,counts,position,ionType,radii,nTable,dmax,dbulk,derode,nmin,core,count] = clusterDataReaderDetails(clusterDataFile)
% [elements,countsDecomp,counts,position,ionType,rg,nTable,dmax,dbulk,...
% derode,nmin,core,count] = clusterDataReaderDetails(clusterDataFile)
% countsDecomp = decomposed elemental counts per cluster
% counts = ion counts per cluster (ions defined in ionType cell)
% count = total number of clusters
% core = core ion used in dmax
% nTable = solute ions per cluster
% This is to read cluster data exported from IVAS and return the details of
% the clusters and the dmax settings that were used
% If you have run this function before then it can use ionsData.xls if it
% is in the same directory
% A London 2013

%check for cached ionsData file
if(exist('ionsData.mat','file'))
    % use cached matlab file
    load ionsData.mat
elseif(exist('ionsData.xls','file'))
    % read ionsData.xls file if present:
    % read data file
    [num_e,elements]=xlsread('ionsData.xls',1,'1:1'); % was 'A:A'
    disp('Read ionsData.xls');
    elements = transpose(elements);
    % read the rest of the file
    [~,~,iall]=xlsread('ionsData.xls');
    ions = iall(2:end,:); % crop the data ignoring first row
    % free memory
    clear iall;
else
    % generate a new ionsData.xls file
    disp('Did not find ionsData.xls... making a new one');
    ionsFile = ionsDataMaka(['Fe';'Cr';'Y ';'Ti';'O ';'C ';'N ';'Si';'Ar';'Mn';'W ';'Ga']);
    disp(strcat('Made new ionsData.xls file:',ionsFile));
end

% Open the file and count the clusters
[dmax,dbulk,derode,nmin,core,count,ionNum] = clusterSettingsNumeric(clusterDataFile);

% display clusters found
disp(strcat(num2str(count),' clusters found'));

if count == 0
    % no particles in this cluster file (I know this is odd but it is for
    % compatibility with other functions)
    countsDecomp = 0;
    counts = 0;
    position = [0,0, 0];
    ionType = 'none';
    radii = 0;
    nTable = 0;
else
% final data will be put here
clusterData = zeros(count,ionNum);
radii = zeros(count,1);
rz = zeros(count,1);
nTable = zeros(count,1);
position = zeros(count,3);
%{
                       < .. Ion complex .. >
cluster ID (up/down)    Cluster counts here
%}
disp(strcat('Reading:',clusterDataFile));
fid = fopen(clusterDataFile);
tline = fgets(fid);
headerFlag = 0;
while ~feof(fid)
    tline = fgets(fid);
    %disp(tline); % debug to get file
    S = sscanf(tline,'%s');
    if(strfind(S,'Count')>9) % if position of 'Count' > 9
        % this is the title line with all the names in, all lines
        % below contain cluster data
        % number of ions
        ionNum = length(strfind(S,'Count'));
        % need to store the data: column, elemental count
        column_data = num2cell(zeros(ionNum,num_e+1));
        column_number = zeros(ionNum,1); % this is  the ',' number in the csv file
        % we have found the counts line
        % extract elements and column positions
        thingy = S; % debugging
        % extract columns
        columns = regexp(S,'[^,]*','match','ignorecase');
        ionType = regexprep(columns(~cellfun(@isempty,strfind(columns,'Count'))),'Count','');
        %disp(columns) % debug
        % Cycle through all 'ions'+'Count'
        % this will find the starting column
        potentialStart = zeros(length(ions),1);
        for i = 1:length(ions)
            found = find(ismember(columns, strcat(ions(i,1),'Count'))==1);
            if(numel(found)==0)
                potentialStart(i) = NaN;
            else
                potentialStart(i) = found(1);
            end
        end
        % check we have look at all the ions:
        disp(strcat('Found:',num2str(sum(potentialStart>0)),' ions'));
        % now we have all the ions (hopefully)
        % take the min find the first one
        startingCol = min(potentialStart);
        % this contains commas so remove them
        %data_ions = strrep(data_ions,',','');
        row = 1; % the current row of the column_data
        % Note FeCount is after the (startingCol)th  ','
        %lets count commas
        comma=0;
        comma_array = zeros(length(strfind(S,',')),2);
        %{
        Comma Array
        1 1
        2 9
        3 27
        4 40
        ... etc
        comma no. and index
        %}
        for i=1:length(S);
            if(strcmp(',',S(i)));
                comma=comma+1;
                comma_array(i,1) = comma;
                comma_array(i,2) = i;
            end;
        end
        for m = startingCol:length(columns)
            for n = 1:length(ions)
                % scan all ions (n) and all columns (m)
                if(strcmp(columns{m},strcat(ions{n,1},'Count'))) % found match
                    column_data(row,:) = ions(n,:); % copies a line from ions
                    % ',' position at:
                    findRes = strfind(S,strcat(ions{n},'Count'));
                    %disp(strcat('Found',ions{n},'Count')); % debug
                    findResLength = size(findRes,2); % length of search results
                    if(findResLength == 1) % found only one result
                        column_number(row,1) = comma_array(findRes(1,1)-1,1);
                        %disp(strfind(S,strcat(ions{n},'Count'))-1);
                        row = row + 1;
                    else
                        %loop through search results
                        for p=1:(findResLength)
                            if(thingy(findRes(1,p)-1)==',') % this is because a search for 'OCount' returns the correct column as well as Fe'OCount' etc
                                column_number(row,1) = comma_array(findRes(1,p)-1,1);
                                %disp(strfind(S,strcat(ions{n},'Count'))-1);
                                row = row + 1;
                            end
                        end
                    end
                end
            end
        end
        headerFlag = 1;
    end
    if headerFlag == 1
        % this is still headers
        headerFlag = 2;
    elseif headerFlag == 2
        % this is the matrix
        headerFlag = 3;
    elseif headerFlag == 3
        % this is cluster data
        clusterID = sscanf(S,'Cluster%d');
        %disp(clusterID); % debug
        % count commas
        comma = 0;
        for i=1:length(S);
            if(strcmp(',',S(i)));
                
                comma=comma+1; % found comma
                
                if comma == 1
                    % Solute ions (total number of core ions)
                    % This is used for nmin filtering
                    nTable(clusterID) = sscanf(S((i+1):end),'%d');
                elseif comma == 4
                    % X Y Z centre positions
                    pos_s = sscanf(S((i+1):end),',%f,%f,%f,')';
                    position(clusterID,:) = pos_s;
                elseif comma == 8
                    radii_s = sscanf(S((i+1):end),'%f,%f,%f');
                    radii(clusterID) = sqrt(radii_s(1)*radii_s(1)+radii_s(2)*radii_s(2)+radii_s(3)*radii_s(3));
                    rz(clusterID) = radii_s(3);
                elseif comma == (column_number(1) - 1)
                    %disp(S((i+2):(length(S)))); % debug
                    %disp(sscanf(S((i+1):(length(S))),',%d')); % debug
                    clusterData(clusterID,:) = sscanf(S( (i+1):end ),',%d');
                    %disp(row);
                    %row = row + 1;
                end
                % end
            end
        end
    end
    
end
fclose(fid);

% now we have clusterData! Time to decompose those counts
% decomposed counts
mym = cell2mat(column_data(:,2:size(column_data,2))); % crop and convert column_data (remove labels)
% multiply!
countsDecomp = clusterData*mym; % decomposed counts
counts = clusterData;
end
end