# given a file name and a date frame, stores the data in the hd5 format using the bioconductor rhdf5 functions
# checks the data type of each variable and the strings are separated out and saved separately
# The data structure can be restored using the h5dataframe.read function
h5dataframe.write <- function(dataFrame, fileName){
  # requires rhdf5 from:
  # source("http://bioconductor.org/biocLite.R")
  # biocLite("rhdf5") 
  require("rhdf5")
  # get classes
  classList <- sapply(dataFrame,class)
  h5createFile(fileName) 
  h5write(dataFrame, fileName,"df")
  h5write(classList, fileName,"classList")
  H5close()
}

# given a file name returns the data stored in the hd5 format using the bioconductor rhdf5 functions
# checks the data type of each variable and the strings are separated out and loaded separately
# The data structure can be saved using the h5dataframe.write function
h5dataframe.read <- function(fileName){
  dataFrameOut <- h5read(fileName,"df")
  classList <- h5read(fileName,"classList")
  convert.magic1(dataFrameOut, classList)
}


convert.magic1 <- function(obj,types){
  out <- lapply(1:length(obj),FUN = function(i){FUN1 <- switch(types[i],
                                                               character = as.character,
                                                               numeric = as.numeric,
                                                               integer = as.integer,
                                                               factor = as.factor); FUN1(obj[,i])})
  names(out) <- colnames(obj)
  as.data.frame(out,stringsAsFactors = TRUE)
}