# ---- func-SRIM2dpa ----
SRIM2dpa <- function(fileName, dose = 1.5E17, atoms = 8.48E14) {
  # reads the VACANCY.txt file produced by SRIM
  # atoms = number of atoms in a 1 angstrom thick layer of area A
  # dose = number of ions per area A (eg per 1 cm^2)
  # returns a data frame, names: depth, ions, recoils, total, dpa
  # library(data.table)
  # library("dplyr")
  
  # read file using fread
  vac <- fread(fileName, header=TRUE, nrows=100, sep=" ", skip="-----------  -----------  ------------")
  # rename and select columns
  setnames(vac,c("depth","ions","recoils")) %>% select(depth,ions,recoils) %>% mutate(total=ions+recoils, dpa=total*dose/atoms)
}
