#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Mon Apr  6 16:59:43 2020

@author: aurelien
"""

import numpy as np
import matplotlib.pyplot as plt
import glob

from scipy.optimize import curve_fit
from pyfcs.fitting import Gc,Gt
from pyfcs.io import open_SIN


def fitter(tau,N,tauD,T,tau_T):
    return Gc(tau,N,tauD,K,1)*Gt(tau,T,tau_T)

def get_taut(corr, plot=True, return_all = False, first_index = 2):
    
    bounds = ((0.01,0.01,0,10**-3),
              (1000,1,1,2*10**-2))
    x,y = corr[first_index:,0],corr[first_index:,1]
    print(x.min())
    popt,_ = curve_fit(fitter,x,y,bounds = bounds)
    yh = fitter(x,*popt)
    if plot:
        plt.figure()
        plt.semilogx(x,y)
        plt.semilogx(x,yh,color="k",linestyle="--")
        plt.title("start at "+str(first_index)+" us")
    if return_all:
        return popt
    return popt[3]


PLOT_ALL = False
plt.close("all")
MSIZE = 3
m_quality = 30
first_index = 2
K = 4

path = "../../data_analysis/FCS/2018_11_28/10s/"
folders = glob.glob(path+'*/')
folders.sort()
f1 = folders.pop(0)
folders.append(f1)
files_2 = folders

#corr = multipletau.autocorrelate(confocal[0],deltat=10**-3,normalize = True)
#corr2 = multipletau.autocorrelate(confocal[1],deltat=10**-3,normalize = True)


all_tt3s = list()
all_amplitudes = list()

for j in range(len(files_2)):
    file = glob.glob(files_2[j]+"/*.npy")[0]
    corr3 = np.load(file)
    # msk = corr3[:,0]<10**-1
    # corr3 = corr3[msk]
    popt = get_taut(corr3, plot=False, return_all = True)
    tt3 = popt[3]
    triplet_amplitude = popt[2]
    all_tt3s.append(tt3)
    all_amplitudes.append(triplet_amplitude)
    print("Average transit time 3:",tt3)
    
all_tt3s = np.array(all_tt3s)*10**3

plt.figure(figsize = (5,2.5))
plt.subplot(1,2,1)
plt.hist(all_tt3s, bins = 5)
plt.axvline(np.mean(all_tt3s),color="red")
plt.xlabel(r"$ \rm Triplet\ correlation\ time\ (\mu s)$")
plt.ylabel("Occurence")

plt.subplot(1,2,2)
plt.hist(all_amplitudes,bins=5)
plt.axvline(np.mean(all_amplitudes),color="red")
plt.xlabel("Triplet amplitude")
plt.ylabel("Occurence")
plt.tight_layout()
plt.savefig("triplet_parameters.svg")

