#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Apr  3 10:52:49 2020

@author: aurelien
"""

import numpy as np
import matplotlib.pyplot as plt

from resolutions_comparisons2 import fit_slice, func_dict, gres
from aotools.ext.graphics import plot_n

def test_fit_slice(plot = True):
    kk = list(func_dict.keys())
    for j in range(len(kk)):
        k = kk[j]
        pars_example = [ 15, 48.52918733,  2.41135554,  6.28476037, 36.5517033 ,
                1.05329441]
        
        u,v = 30,100
        x,y = np.arange(u), np.arange(v)
        xc,yc = np.meshgrid(x,y)
        f = func_dict[k]
        profile = f([xc,yc],*pars_example)
        
        fits = []
        for jj in range(len(kk)):
            popt,coords = fit_slice(profile,model=kk[jj])
            new_profile = func_dict[kk[jj]](coords,*popt)
            fits.append(new_profile)
        residuals= [gres(profile,w) for w in fits]
        assert(residuals[j]==min(residuals))
    if plot:
        plot_n(fits, titles = kk)
        plt.figure()
        plt.imshow(profile)
        
test_fit_slice()