#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Fri Apr  3 11:32:34 2020

@author: aurelien

'Don't believe everything you read on the internet' Gengis Khan

"""
import numpy as np
import matplotlib.pyplot as plt

import glob
import sys
sys.path.append("../..")
from constants import FIG_UNIT, PLOT_DEFAULT
from scipy.stats import linregress
import pickle
from resolutions_comparisons import (extract_resolutions, 
                                     analyse_folder, exp_fitter, linear_fitter,
                                     resolutions_vs_powers)
plt.close("all")

confocal_file = "../../data_analysis/Beads/raw_data/29_01_2019/confocal_2901.json"
#path_confocal_stack = "/media/aurelien/362228e7-97c8-487c-b5d0-2d548f964446/Data/2019_01_29/beads/"
x1,z1,x2,z2 = extract_resolutions(confocal_file)
print("Resolutions confocal:",np.mean(x1),np.mean(z1),np.mean(x2),np.mean(z2))
print("Aspect ratios:",np.mean(z1)/np.mean(x1),np.mean(z2)/np.mean(x2))
CONFOCAL_X = np.mean(x1)
CONFOCAL_Z = np.mean(z1)


PLOT_DEFAULT["CH07"] = {'marker': 'P', 'color': '#52a8e4ff'}
PLOT_DEFAULT["CH09"] = {'marker': 'D', 'color': '#165f91ff'}

PLOT_DEFAULT["3D_10"] = {'marker': 'P', 'color': '#c25b00ff'}
PLOT_DEFAULT["3D_30"] = {'marker': 'D', 'color': '#f7a45aff'}

kwargs_keys = ["2D","z","CH07","CH","CH09","3D","3D_30"]

names = ["2D","z",r"$ \rm CH, \rho = 0.7$",r"$ \rm CH, \rho = 0.8$",
         r"$ \rm CH, \rho = 0.9$","3D, 60/40","3D, 25/75"]

# Paths to Image stacks
raw_data_path = "/home/aurelien/Documents/phd/manuscripts/02_CH_STED/data_analysis/Beads/raw_data/"

folders_names = ["2D","z","CH07","CH08","CH09",
                 "double_angle20","double_angle30"]
# folders_names = ["2D","z"]
stacks_paths = [raw_data_path+"28_11_2018/"+w+"/" for w in folders_names]
stacks_paths[1] = raw_data_path+"29_01_2019/z/"
K_CONFOCAL = 4

#analyse_folder(stacks_paths[1],"exp",confocal_file,plot=True,
#                                        plot_kwargs = PLOT_DEFAULT[kwargs_keys[jn]])
#1/0

fdict = {"lin":linear_fitter,
         "exp":exp_fitter}
ANALYSE_FOLDERS_RESOLUTIONS = True

if ANALYSE_FOLDERS_RESOLUTIONS:
    # z vs x plot
    fig,ax = plt.subplots(figsize= (FIG_UNIT*1.5,FIG_UNIT*1.5))
    # k vs x plot
    fig2,ax2 = plt.subplots(figsize= (FIG_UNIT*1.5,FIG_UNIT*1.5))

    ax2.set_xlabel(r"$ \rm \omega_{xy}/\omega_{xy,confocal}$")
    ax2.set_ylabel(r"$ \rm K$")
    
    fitter_type=["lin","exp","lin","lin","lin","lin","exp"]

    all_res_fits = []
    all_xys = []
    all_pw_res = []
    
    for jn,(folder,ft) in enumerate(zip(stacks_paths,fitter_type)):
        name = folder.split("/")[-2]
        print('analysing folder',name,ft)
        x,y,out,fitter = analyse_folder(folder,ft,confocal_file,ax=ax, plot_results = True,
                                        plot_kwargs = PLOT_DEFAULT[kwargs_keys[jn]],
                                        name=names[jn],plot=False)
    
        all_res_fits.append((name,out,ft))
        all_xys.append((x,y))
        
        pw,resolutions = resolutions_vs_powers(folder,confocal_file,plot=False)
        resolutions = resolutions[:,:2]
        resolutions /= CONFOCAL_X
        
        ks = resolutions[:,1]/resolutions[:,0]
        ks[0,:] = K_CONFOCAL
        
        ks_mean = np.mean(ks,axis=1)
        ks_std = np.std(ks,axis=1)
        x_mean = np.mean(resolutions[:,0],axis=1)
        x_std = np.std(resolutions[:,0],axis=1)
        
        x_fit = np.linspace(x_mean.min()/x_mean.max()*0.8,1,10)[::-1]
        z_fit = fdict[ft](x_fit,*out)
        k_fit = z_fit/x_fit * CONFOCAL_Z/CONFOCAL_X
        k_fit[0] = K_CONFOCAL
        
        if name=="2D":
            k_fit = z_fit/x_fit * K_CONFOCAL
        # x_fit*=CONFOCAL_X
        #ax2.errorbar(x_mean, ks_mean, xerr=x_std, yerr=ks_std,
        #             **PLOT_DEFAULT[kwargs_keys[jn]],label = names[jn])
        ax2.plot(x_fit,k_fit,color=PLOT_DEFAULT[kwargs_keys[jn]]["color"],
                 label = names[jn])
        
        all_pw_res.append((pw,resolutions))
    ax.set_xlabel(r"$ \rm \omega_{xy}/\omega_{xy,confocal}$")
    ax.set_ylabel(r"$ \rm \omega_{z}/\omega_{z,confocal}$")
    ax.set_xlim(right=1.1)
    
    fig.tight_layout()
    ax.legend()
    fig.savefig('beads_fitting.svg',transparent = True)
    
    ax2.legend()
    fig2.tight_layout()
    fig2.savefig("beads_fit_AR.svg",transparent = True)
    
    radii = [0.7,0.8,0.9]
    ch_indices = [2,3,4]
    slpes = [all_res_fits[j][1] for j in ch_indices]
    slpes = np.array(slpes).reshape(-1)
    plt.figure()
    plt.plot(radii,slpes,"o")
    out_linregress = linregress(radii,slpes)
    slope,intercept = out_linregress[0], out_linregress[1]
    plt.plot(np.linspace(0,1,10),np.linspace(0,1,10)*slope+intercept)
    plt.legend(["Data","fit"])
    plt.xlabel("CH radius")
    plt.ylabel("slope of linear fitter")
    
    wanted_radii = np.round(np.linspace(0.55,1,10),2)
    
    #dict 2 contains all the results
    dict2 = {}
    for w in wanted_radii:
        if w*slope+intercept >0:
            dict2[w] = ([w*slope+intercept],'lin')
        else:
            dict2[w] = ([0],'lin')
            
    for nm,par,fitn in all_res_fits:
        if 'CH' not in nm:
            dict2[nm] = (par,fitn)
    
    #dict2[1] = ([0],'lin')
    dict2["Kconf"] = CONFOCAL_Z/CONFOCAL_X
    with open("fit_dictionay_extrapolated.json","wb") as fd:
        pickle.dump(dict2,fd)
    
        
    slopes = np.array([dict2[r][0] for r in wanted_radii]).reshape(-1)
    """
    plt.figure()
    plt.plot(wanted_radii,slopes,"-o")
    plt.xlabel("CH radius")
    plt.ylabel("slope")"""
    

