# -*- coding: utf-8 -*-
"""
Created on Tue Mar  3 10:26:44 2020

@author: univ4208
"""

import matplotlib.pyplot as plt
import glob

from accessories.io import generate_names_list_dict
from pyfcs.fitting import Curve, FcsFitter,Gc,Gt

import numpy as np
import sys
sys.path.append("../..")
from constants import PLOT_FONT_SIZE
import matplotlib
from pyfcs.io import open_SIN
from scipy.optimize import curve_fit

#Definition of functions
def Gconf(tau,N,tauD,T,alpha):
    return Gc(tau,N,tauD,K_CONFOCAL,alpha) * Gt(tau,T,TAU_T)

# Layout and stuff
font = {'size'   : PLOT_FONT_SIZE}

matplotlib.rc('font', **font)

plt.close("all")

folders = glob.glob("../../data_analysis/FCS/2018_10_19/*/")

fz = [f for f in folders if "3D STED" in f][0]
fch = [f for f in folders if "CH" in f][0]
f3d = [f for f in folders if "3D_50 2D_50" in f][0]

K_CONFOCAL = 4
TAU_T = 5*10**-3

bounds = ((10**-3,10**-3,0,0),(1000,1,1-1e-3,1))

out_ch = generate_names_list_dict(fch)
out_z = generate_names_list_dict(fz)
out_3d= generate_names_list_dict(f3d)


fitter = FcsFitter("z",Gconf,bounds,bounds)

confocals = out_ch[0] + out_z[0] + out_3d[0] 
opsin = lambda x: open_SIN(x)[0]
curves = [Curve(corr = opsin(w),power=0,fitter=Gconf,bounds=bounds,first_n=5) for w in confocals ]
[w.fit() for w in curves]

fig,axes = plt.subplots(1,2)
alphas = []
for j in range(len(confocals)):
    curve = curves[j]
    curve.plot(axes=axes,offset = j*0.2)
    alphas.append(curve.popt[3])

plt.figure(figsize = (2.5,2.5))
plt.hist(alphas, color="gray")
plt.axvline(np.median(alphas),color="red")
plt.xlabel(r"$\rm \alpha$")
plt.ylabel(r"$\rm Occurences$")
plt.tight_layout()
plt.savefig("histo_alpha.svg")

ind0 = 5
curve = curves[ind0]
curve.plot()

def Gconf1(tau,N,tauD,T):
    return Gc(tau,N,tauD,K_CONFOCAL,curve.popt[-1]) * Gt(tau,T,TAU_T)

def Gconf2(tau,N,tauD,T):
    return Gc(tau,N,tauD,K_CONFOCAL,1) * Gt(tau,T,TAU_T)

bounds1 = ((10**-3,10**-3,0.15),(1000,1,0.15+1e-3))
x = curve.x
y = curve.y

msk = x>10*10**-3
x = x[msk]
y = y[msk]

popt1,_ = curve_fit(Gconf1,x,y,bounds=bounds1)
popt2,_ = curve_fit(Gconf2,x,y,bounds=bounds1)
yh1 = Gconf1(x,*popt1)
yh2 = Gconf2(x,*popt2)

plt.figure(figsize=(5,2.5))
plt.subplot(121)
plt.semilogx(x,y,color="black")
plt.semilogx(x,yh1,color="green",linestyle="--")
plt.semilogx(x,yh2,color="m",linestyle="-.")
plt.xlabel(r"$\rm \tau\ (ms)$")
plt.ylabel(r"$\rm G(\tau)$")
plt.gca().ticklabel_format(axis="y",style="sci")
plt.locator_params(axis='y', nbins=3)

plt.subplot(122)
plt.semilogx(x,y-yh2,color="m",linestyle="-.",label=r"$\alpha=1$")
plt.semilogx(x,y-yh1,color="green",linestyle="--", label=r"$\alpha=0.7$")
plt.locator_params(axis='y', nbins=3)
plt.xlabel(r"$\rm \tau\ (ms)$")
plt.ylabel(r"$\rm Residuals$")
plt.legend()
plt.tight_layout()
plt.savefig("Alpha_curves.svg")