#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
Created on Thu Nov 28 14:51:24 2019

@author: aurelien
"""
#file = "silviacell.tiff", un truc comme ca

import matplotlib.pyplot as plt

from accessories.io import get_tiff_img
from accessories.plotting import fiji_lut, plot_scalebar, get_extent

from accessories.misc import cres
import numpy as np
plt.rcParams['svg.fonttype'] = 'none'
plt.close("all")

COLORBAR = False

cz1 = 35
cz2 = None
cx1 = None
cx2 = None

shrinkv = 0.9

def preprocess(img):
    return img[cz1:cz2, cx1:cx2]

pathgfp = "../../data_analysis/FCS/2018_11_16/cell2_meas1-5left,6-9right.msr - Ch1 {0}.tif"
path = "../../data_analysis/FCS/2018_11_16/cell2_meas1-5left,6-9right.msr - Ch2 {0}.tif"

conf,resc = get_tiff_img(pathgfp, preprocess = preprocess)
sted,ress = get_tiff_img(path, preprocess = preprocess)
conf = np.rot90(conf)
sted = np.rot90(sted)
resc = resc[::-1]
ress = ress[::-1]

x1,y1 = plot_scalebar(sted,ress, pos = [0.1,0.8],axis=1,size=5)
assert(cres(resc,ress))
extent = get_extent(sted,ress)

cmap_sted = "hot"
plt.figure(figsize = (8,4))
plt.subplot(121)
plt.imshow(conf, cmap = fiji_lut("Green"), extent = extent,vmin=0)
if COLORBAR:
    plt.colorbar(ticks = [0,conf.max()], shrink = shrinkv, aspect = 10)
plt.axis("off")

plt.subplot(122)
plt.imshow(sted,cmap = cmap_sted, extent = extent,vmin=0)
if COLORBAR:
    plt.colorbar(ticks = [0, sted.max()], shrink = shrinkv, aspect = 10)
plt.plot(x1,y1,color="white",linewidth = 2, solid_capstyle = "butt")
plt.axis("off")
plt.savefig("fig2_fullptk2.svg", dpi = 1200)

