%% plot delta_c/tau^(2/3) vs tau

% load num & exp data
load('delta_ExpGamma22.mat') % tau; delta_c; error on delta_c
load('delta_ExpGamma72.mat') % tau; delta_c; error on delta_c
load('Num_Det_Method.mat'); Num_Det = sum2;  % tau; N_onset; delta_c
load('Indent_PVS_Feb2017.mat')  % h (mum); tau; delta_c; error on delta_c; N_onset 

% plot data
figure; hold on
errorbar(delta_ExpGamma72(:,1).^(-2/3),delta_ExpGamma72(:,1).^(-2/3).*delta_ExpGamma72(:,2),delta_ExpGamma72(:,1).^(-2/3).*delta_ExpGamma72(:,3),'ro','MarkerSize',10,'MarkerFaceColor','auto')
errorbar(delta_ExpGamma22(:,1).^(-2/3),delta_ExpGamma22(:,1).^(-2/3).*delta_ExpGamma22(:,2),delta_ExpGamma22(:,1).^(-2/3).*delta_ExpGamma22(:,3),'bv','MarkerSize',10,'MarkerFaceColor','auto')
errorbar(Indent_PVS_Feb2017(:,2).^(-2/3),Indent_PVS_Feb2017(:,2).^(-2/3).*Indent_PVS_Feb2017(:,3),Indent_PVS_Feb2017(:,2).^(-2/3).*Indent_PVS_Feb2017(:,4),'gsq','MarkerSize',10,'MarkerFaceColor','auto')
plot(Num_Det(:,1).^(-2/3),Num_Det(:,1).^(-2/3).*Num_Det(:,3),'x')


% format figure
set(gca,'xscale','log')
set(gca,'yscale','log')
xlim([0.05 20])
xlabel('$\tau^{-2/3} \sim h$','Interpreter','Latex')
ylabel('$\delta_{c}/\tau^{2/3}\sim \zeta_0^{(c)}$','Interpreter','Latex') 
legend('Exp \gamma_{lv} = 72 mNm^{-1}','Exp \gamma_{lv} = 22 mNm^{-1}','Exp PVS','Numerics','Location','northwest')
box on
set(gca,'FontName','Times New Roman','Fontsize', 18);