%% Here we want to show the stress profiles in the natural non-dimensionalization, and with the rescaling

close all;clear all;

%% Alternative is to plot more values of tau, but only have one plot for each value of delta

tauvals=[0.1;1;10];
cols='rgb';

w0=1;

for i=1:length(tauvals)
    tau=tauvals(i);
    inpt=load(strcat('StressProfileTau=',num2str(tau),'w0=',num2str(w0),'.txt'));
    r=inpt(:,1);
    srr=inpt(:,2);
    sqq=inpt(:,3);
    
    % Raw data first
    figure(2)
    plot(r,sqq,strcat(cols(i),'-.'))
    hold on

    figure(100)
    plot(r./sqrt(w0),(sqq-tau)./w0,strcat(cols(i),'-.'))
    hold on
end

w0=100;

for i=1:length(tauvals)
    tau=tauvals(i);
    inpt=load(strcat('StressProfileTau=',num2str(tau),'w0=',num2str(w0),'.txt'));
    r=inpt(:,1);
    srr=inpt(:,2);
    sqq=inpt(:,3);
    
    % Raw data first
    figure(3)
    plot(r,sqq,strcat(cols(i),'--'))
    hold on

    figure(100)
    plot(r./sqrt(w0),(sqq-tau)./w0,strcat(cols(i),'--'))
    hold on
end

w0=1000;

for i=1:length(tauvals)
    tau=tauvals(i);
    inpt=load(strcat('StressProfileTau=',num2str(tau),'w0=',num2str(w0),'.txt'));
    r=inpt(:,1);
    srr=inpt(:,2);
    sqq=inpt(:,3);
    
    % Raw data first
    figure(4)
    plot(r,sqq,strcat(cols(i),'-'))
    hold on

    figure(100)
    plot(r./sqrt(w0),(sqq-tau)./w0,strcat(cols(i),'-'))
    hold on
end

figure(2)
xlabel('$r/\ell_g$','interpreter','latex')
ylabel('$\sigma_{\theta\theta}/(B\rho g)^{1/2}$','interpreter','latex')
axis([0.01 15 -5 15])
set(gca,'ticklength',2*get(gca,'ticklength'))
hold off

figure(3)
xlabel('$r/\ell_g$','interpreter','latex')
ylabel('$\sigma_{\theta\theta}/(B\rho g)^{1/2}$','interpreter','latex')
axis([0 50 -30 15])
set(gca,'ticklength',2*get(gca,'ticklength'))
hold off

figure(4)
xlabel('$r/\ell_g$','interpreter','latex')
ylabel('$\sigma_{\theta\theta}/(B\rho g)^{1/2}$','interpreter','latex')
axis([0 150 -300 15])
set(gca,'ticklength',2*get(gca,'ticklength'))
hold off



figure(100)
axis([0.01 3 -0.5 2])
xlabel('$r/[\ell_g(\zeta_0/h)^{1/2}]$','interpreter','latex')
ylabel('$\sigma_{\theta\theta}/[(B\rho g)^{1/2}\zeta_0/h]$','interpreter','latex')
set(gca,'ticklength',2*get(gca,'ticklength'))

hold off

