function [out1]=CalcDets(nu,r,w,wp,w2p,w3p,psi,psip,nvals)

% Use splines to calculate the zeroth order problem on a regularly spaced
% grid

x0=r(1);
Lnew=100;
N=100; % The number of grid points used to discretize the problem
xx=linspace(x0,Lnew,N+1);
dx=xx(2)-xx(1);

z0=spline(r,w,xx);
z0p=spline(r,wp,xx);
z0pp=spline(r,w2p,xx);
z0ppp=spline(r,w3p,xx);
psi0=spline(r,psi,xx);
psi0p=spline(r,psip,xx);

% setup the matrices for the eigenvalue problem (A2*lam^2+A1*lam+A0)*x=0

A2=sparse([],[],[],2*N+2,2*N+2,2*N+2);
A1=sparse([],[],[],2*N+2,2*N+2,10*N);
A0=sparse([],[],[],2*N+2,2*N+2,20*N+2);

% Deal with A2 first (the easiest)
% conditions on first and last two elements come from boundary conditions
% so skip those rows here

tic
for i=3:(N-1)
    A2(i,i)=1./(xx(i))^4;
    A2(i+N+1,i+N+1)=1./(xx(i))^4;
end
toc

% Deal with A1 next
tic
for i=3:(N-1)
    R=xx(i);
    A1(i,i)=psi0p(i)./(R^2)-4./(R^4);
    A1(i,i+N+1)=z0pp(i)./(R^2);
    A1(i,i-1)=-2/R^3*1/(2*dx);
    A1(i,i+1)=2/R^3*1/(2*dx);
    A1(i,i-1)=A1(i,i-1)-2/R^2*1/(dx^2);
    A1(i,i+1)=A1(i,i+1)-2/R^2*1/(dx^2);
    A1(i,i)=A1(i,i)+4/R^2*1/(dx^2);
    
    A1(i+N+1,i)=12*(1-nu^2)*z0pp(i)./R^2;
    A1(i+N+1,i+N+1)=-4./R^4;
    A1(i+N+1,i+N+2)=2/R^3*1/(2*dx);
    A1(i+N+1,i+N)=-2./R^3*1/(2*dx);
    A1(i+N+1,i+N)=A1(i+N+1,i+N)-2./R^2*1/(dx^2);
    A1(i+N+1,i+N+2)=A1(i+N+1,i+N+2)-2./R^2*1/(dx^2);
    A1(i+N+1,i+N+1)=A1(i+N+1,i+N+1)+4./R^2*1/(dx^2);
    
end
toc

% Finally sort out A0
tic
A0(1,1)=1; % Enforces the boundary condition z1(0)=0
% Enforce the boundary condition z1'(0)=0
A0(2,1)=3; A0(2,2)=-4; A0(2,3)=1;
% Enforce the boundary condition z1'(inf)=0
A0(N,N-1)=1;A0(N,N)=-4;A0(N,N+1)=3;
% Enforce the boundary condition z1(inf)=0
A0(N+1,N+1)=1;

% Enforce the bc chi1(0)=0 (arbitrary choice)
A0(N+2,N+2)=1;
% enforce the bc x*chi''(0)-nu*chi'(0)
A0(N+3,N+2)=-nu*(-1.5/dx)+2*x0/dx^2;A0(N+3,N+3)=-nu*(2/dx)-5*x0/dx^2;A0(N+3,N+4)=-nu*(-0.5/dx)+4*x0/dx^2;A0(N+3,N+5)=-x0/dx^2;
% The bc chi''(inf)=0
A0(2*N+1,2*N+2-3)=-1;A0(2*N+1,2*N+2-2)=4;A0(2*N+1,2*N+2-1)=-5;A0(2*N+1,2*N+2)=2;
% The bc chi'(inf)=0
A0(2*N+2,2*N+2-2)=-1;A0(2*N+2,2*N+2-1)=4;A0(2*N+2,2*N+2)=-3;

for i=3:(N-1)
    R=xx(i);
    A0(i,i)=1;
    
    fac=(1/R^3-psi0p(i)/R);
    A0(i,i+1)=fac/(2*dx);
    A0(i,i-1)=-fac/(2*dx);
    
    fac=-(psi0(i)/R+1/R^2);
    A0(i,i+1)=A0(i,i+1)+fac/dx^2;
    A0(i,i)=A0(i,i)-2*fac/dx^2;
    A0(i,i-1)=A0(i,i-1)+fac/dx^2;
    
    fac=2/R;
    A0(i,i-2)=A0(i,i-2)+fac*(-1/(2*dx^3));
    A0(i,i-1)=A0(i,i-1)+fac*(2/(2*dx^3));
    A0(i,i+1)=A0(i,i+1)+fac*(2/(2*dx^3));
    A0(i,i+2)=A0(i,i+2)+fac*(-1/(2*dx^3));
    
    A0(i,i-2)=A0(i,i-2)+(1/(dx^4));
    A0(i,i-1)=A0(i,i-1)+(-4/(2*dx^4));
    A0(i,i)=A0(i,i)+(6/(2*dx^4));
    A0(i,i+1)=A0(i,i+1)+(-4/(2*dx^4));
    A0(i,i+2)=A0(i,i+2)+(1/(2*dx^4));
    
    fac=-z0pp(i)/R;
    A0(i,i+N+1-1)=-fac/(2*dx);
    A0(i,i+N+1+1)=fac/(2*dx);
    
    fac=-z0p(i)/R;
    A0(i,i+N+1-1)=A0(i,i+N+1-1)+fac/(dx^2);
    A0(i,i+N+1)=A0(i,i+N+1)-2*fac/(dx^2);
    A0(i,i+N+1+1)=A0(i,i+N+1+1)+fac/(dx^2);
    
    fac=12*(1-nu^2)*z0p(i)/R;
    A0(i+N+1,i-1)=A0(i+N+1,i-1)+fac/(dx^2);
    A0(i+N+1,i)=A0(i+N+1,i)-2*fac/(dx^2);
    A0(i+N+1,i+1)=A0(i+N+1,i+1)+fac/(dx^2);
    
    fac=12*(1-nu^2)*z0pp(i)/R;
    A0(i+N+1,i-1)=A0(i+N+1,i-1)-fac/(2*dx);
    A0(i+N+1,i+1)=A0(i+N+1,i+1)+fac/(2*dx);
    
    fac=1/R^3;
    A0(i+N+1,i+N+1-1)=A0(i+N+1,i+N+1-1)-fac/(2*dx);
    A0(i+N+1,i+N+1+1)=A0(i+N+1,i+N+1+1)+fac/(2*dx);
    
    fac=-1/R^2;
    A0(i+N+1,i+N+1-1)=A0(i+N+1,i+N+1-1)+fac/(dx^2);
    A0(i+N+1,i+N+1)=A0(i+N+1,i+N+1)-2*fac/(dx^2);
    A0(i+N+1,i+N+1+1)=A0(i+N+1,i+N+1+1)+fac/(dx^2);
    
    fac=2/R;
    A0(i+N+1,i+N+1-2)=A0(i+N+1,i+N+1-2)-fac/(2*dx^3);
    A0(i+N+1,i+N+1-1)=A0(i+N+1,i+N+1-1)+2*fac/(2*dx^3);
    A0(i+N+1,i+N+1+1)=A0(i+N+1,i+N+1+1)+2*fac/(2*dx^3);
    A0(i+N+1,i+N+1+2)=A0(i+N+1,i+N+1+2)-fac/(2*dx^3);

    fac=1;
    A0(i+N+1,i+N+1-2)=A0(i+N+1,i+N+1-2)+fac/(dx^4);
    A0(i+N+1,i+N+1-1)=A0(i+N+1,i+N+1-1)-4*fac/(dx^4);
    A0(i+N+1,i+N+1)=A0(i+N+1,i+N+1)+6*fac/(dx^4);
    A0(i+N+1,i+N+1+1)=A0(i+N+1,i+N+1+1)-4*fac/(dx^4);
    A0(i+N+1,i+N+1+2)=A0(i+N+1,i+N+1+2)+fac/(dx^4);
    
end

toc

results=zeros(length(nvals),1);
for i=1:length(nvals)
    lambda=nvals(i)^2;
    mat=lambda^2*A2+lambda*A1+A0;
    results(i)=det(mat);
end
    
out1=results;
    
    


