%% plot n_onset vs tau

% load num & exp data
load('Nonset_ExpGamma22.mat') % tau; N_onset; +/- 1
load('Nonset_ExpGamma72.mat')   % tau; N_onset; +/- 1
load('Num_Det_Method.mat'); Num_Det = sum2; % tau; N_onset; delta_c
load('Indent_PVS_Feb2017.mat')  % h (mum); tau; delta_c; err; N_onset 

% plot data
figure; hold on
errorbar(ExpGamma72(:,1),ExpGamma72(:,2),ExpGamma72(:,3),'ro','MarkerSize',10,'MarkerFaceColor','auto')
errorbar(ExpGamma22(:,1),ExpGamma22(:,2),ExpGamma22(:,3),'bv','MarkerSize',10,'MarkerFaceColor','auto')
n = zeros(9,1); n(:) = 1;
errorbar(Indent_PVS_Feb2017(:,2),Indent_PVS_Feb2017(:,5),n,'gsq','MarkerSize',10,'MarkerFaceColor','auto')
plot(Num_Det(:,1),Num_Det(:,2),'x')

% format figure
set(gca,'xscale','log')
set(gca,'yscale','log')
ylim([5 40])
xlim([1e-2 1e2])
xlabel('$\tau$','Interpreter','Latex')
ylabel('$n_{onset}$','Interpreter','Latex')
legend('Exp \gamma_{lv} = 72 mN/m','Exp \gamma_{lv} = 22 mN/m','Exp PVS','Numerics','Location','northwest')
box on
set(gca,'FontName','Times New Roman','Fontsize', 18);