%% Here we want to just focus on small displacements and check that all is fine 

close all;clear all;

%% Import the exp data

load poking_profiles' D50-1_Load4_h1_5 Check.mat';

nu=0.5;
h = 1.5e-3;
E = 2.06e6;
rhol = 998;
glv=0.0728;
g = 9.81;
lstar = (E*h*zeta0.^2/(rhol*g)).^(1/4);
B=E*h^3/(12*(1-nu^2));
lg=(B/(rhol*g))^(1/4);


%% Second exp data set 

load h2D50deflection.mat

ll = length(deflection);
figure(18); hold on;
figure(19); hold on;

nu=0.5;
h = 1.5e-3;
E = 2.06e6;
rhol = 998;
glv=0.0728;
g = 9.81;

syms='vdsxo';

for qq = 1:5
    ddd=deflection{qq,5};
    ave=mean(ddd(1:20,2));
    y=ave-ddd(:,2);
    [delta ind]=max(y);
    deltam=delta*1e-3;
    r0=ddd(ind,1);
    deltatilde=delta./1.5
    
    r=(ddd(:,1)-r0)*1e-2;
    lstar = (E*h*deltam.^2/(rhol*g)).^(1/4);
    
    if qq==1
        figure(18)
        plot(r(1:5:end)./lstar,-y(1:5:end)./delta,'v','color',[rgb(6-qq,:)],'MarkerSize',10);
        figure(19)
        plot(r(1:5:end)./lg,-y(1:5:end)./delta,'v','color',[rgb(6-qq,:)],'MarkerSize',10);
   
    elseif qq==2
        figure(18)
        plot(r(1:5:end)./lstar,-y(1:5:end)./delta,'d','color',[rgb(6-qq,:)],'MarkerSize',10);
        figure(19)
        plot(r(1:5:end)./lg,-y(1:5:end)./delta,'d','color',[rgb(6-qq,:)],'MarkerSize',10);
        
    elseif qq==3
        figure(18)
        plot(r(1:5:end)./lstar,-y(1:5:end)./delta,'s','color',[rgb(6-qq,:)],'MarkerSize',10);
        figure(19)
        plot(r(1:5:end)./lg,-y(1:5:end)./delta,'s','color',[rgb(6-qq,:)],'MarkerSize',10);
   
    elseif qq==4
        figure(18)
        plot(r(1:5:end)./lstar,-y(1:5:end)./delta,'x','color',[rgb(6-qq,:)],'MarkerSize',10);
        figure(19)
        plot(r(1:5:end)./lg,-y(1:5:end)./delta,'x','color',[rgb(6-qq,:)],'MarkerSize',10);
   
    else
        figure(18)
        plot(r(1:5:end)./lstar,-y(1:5:end)./delta,'o','color',[rgb(6-qq,:)],'MarkerSize',10);
        figure(19)
        plot(r(1:5:end)./lg,-y(1:5:end)./delta,'o','color',[rgb(6-qq,:)],'MarkerSize',10);
   
    end
        
end;

figure(19)
axis([-6 6 -1.1 0.1])
box on
xlabel('$r/{\ell_g}$','interpreter','latex')
ylabel('$\zeta/\zeta_0$','interpreter','latex')
set(gca,'ticklength',2*get(gca,'ticklength'));

hold off

figure(18)
axis([-3 3 -1.1 0.1])
box on
xlabel('$r/{\ell_\ast}$','interpreter','latex')
ylabel('$\zeta/\zeta_0$','interpreter','latex')
set(gca,'ticklength',2*get(gca,'ticklength'));
legend('\delta = 5.15','\delta = 6.20','\delta = 6.97','\delta = 7.76','\delta = 8.43','Location','SouthEast')

tau=0.01;
w0vals=[5 8];
cols='kkk';
fudge=1;

for i=1:length(w0vals)
    w0=w0vals(i);
    inpt=load(strcat('ProfileTau=',num2str(tau),'W0=',num2str(w0),'.txt'));
    r=inpt(:,1);
    z=inpt(:,2);
    
    figure(18);hold on
    plot(r/sqrt(w0)/(12*(1-nu^2))^(1/4),z./w0,strcat(cols(i),'-'))
    plot(-r/sqrt(w0)/(12*(1-nu^2))^(1/4),z./w0,strcat(cols(i),'-'))
    
    
end


hold off

