%% 01/03/17 - Data here includes exps done in Oxford on Pink and Green PVS 
% in petridishes, and exps done in Cambridge on PI, PC and PDMS in large tanks (~1m).
% Numerical data are also included

close all; clear all;

stiffnessvec=zeros(5,2);
    
figure(1); hold on
xlabel('${\cal F}=F/(h(B\rho g)^{1/2})$','Interpreter','LaTex')
ylabel('$\delta = \zeta_0/h$','Interpreter','LaTex')

inpt=load('ForceLawTau=0.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k-')

inpt=load('ForceLawTau=1.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k.-.')

inpt=load('ForceLawTau=5.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k--')

inpt=load('ForceLawTau=10.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k:')

inpt=load('ForceLawTau=33.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k-','LineWidth',1.25)

legend('\tau = 0','\tau = 1','\tau = 5','\tau = 10','\tau = 33','Location','Northwest')
axis([1e-1 1e4 1e-2 1e2])

% Save the stiffness values found here

stiffness=fopen('DimlessFilmStiffnesses_FromRob.txt', 'w');
for ii=1:length(stiffnessvec(:,1))
    fprintf(stiffness,'%.12g\t',stiffnessvec(ii,1));
    fprintf(stiffness,'%.12g\t',stiffnessvec(ii,2));
    fprintf(stiffness,'\n');
end
status=fclose(stiffness);

%% Now plot the Oxford PVS & Polyimide & PC Data
load('rgb.mat'); 

% Then deal with the data for green substrates

hvals=[65,100,169,367,929];
syms='so*xd';
for i=length(hvals):-1:1
    ii = length(hvals)-i+3;
    inpt=load(strcat('Green_H',num2str(hvals(i)),'um.txt'));
    d=inpt(:,1)*1e-6;
    F=inpt(:,2)*1e-6*9.81;
    
    ym=0.8e6;
    nu=0.5;
    glv=72e-3; % value for water
    g=9.81;
    rho=1000; % value for water
    k=rho*g;

    h=hvals(i)*1e-6;
    B=ym*h^3./(12*(1-nu^2));
    tau=glv/sqrt(B*k)
    
    dnd=d./h;
    fnd=F./(h*sqrt(B*k));
    
    if i == 1 || i == 5
     figure(1); hold on  
        idx=zeros(101,1); ll = log(length(dnd)); jj=1; 
        for n = 0:ll/100:ll
        idx(jj) = 1*exp(n); jj=jj+1;
        end
        idx = round(idx);
    loglog(fnd(idx),dnd(idx),strcat('',syms(i)),'Color',rgb(ii,:),'MarkerSize',8);
    end
    
    
    % Now try and quickly estimate the stiffness
    inds=find(dnd<1 & dnd>0);
    k(:,1)=mean(fnd(inds)./dnd(inds));
    k(:,2)=std(fnd(inds)./dnd(inds));
    figure(3)
    errorbar(tau,k(:,1),k(:,2),strcat('',syms(i)),'Color',rgb(ii,:),'MarkerSize',10);
    set(gca,'Yscale','log')
    set(gca,'Xscale','log')
    hold on
   ii
end

% Then deal with the data for the polyimide film
inpt=load(strcat('Polyimide_H8um.txt'));
    d=inpt(:,1)*1e-6;
    F=inpt(:,2)*1e-6*9.81;
    
    glv=72e-3; % value for water
    g=9.81;
    rho=1000; % value for water
    k=rho*g;

    h=8.5e-6;
    B=2.14e-7;
    tau=glv/sqrt(B*k)
    
    dnd=d./h;
    fnd=F./(h*sqrt(B*k));

    figure(1);  
        idx=zeros(101,1); ll = log(length(dnd)); jj=1; 
        for n = 0:ll/100:ll
        idx(jj) = 1*exp(n); jj=jj+1;
        end
        idx = round(idx);
        loglog(fnd(idx),dnd(idx),'+','Color',rgb(6,:),'MarkerSize',8);
    
    set(gca,'Yscale','log')
    set(gca,'Xscale','log')
    box on
    
    % Now try and quickly estimate the stiffness
    inds=find(dnd<1 & dnd>0);
    k(:,1)=mean(fnd(inds)./dnd(inds));
    k(:,2)=std(fnd(inds)./dnd(inds));
    figure(3)
    errorbar(tau,k(:,1),k(:,2),'+','Color',rgb(6,:),'MarkerSize',10);
    set(gca,'Yscale','log')
    set(gca,'Xscale','log')
    
% Then deal with the data for pink substrates

hvals=[26,57,90,244];
syms='^>v<';
ii=1;
for i=length(hvals):-1:1
    inpt=load(strcat('Pink_H',num2str(hvals(i)),'um.txt'));
    d=inpt(:,1)*1e-6;
    F=inpt(:,2)*1e-6*9.81;
    
    ym=0.25e6;
    nu=0.5;
    glv=72e-3; % value for water
    g=9.81;
    rho=1000; % value for water
    k=rho*g;

    h=hvals(i)*1e-6;
    B=ym*h^3./(12*(1-nu^2));
    tau=glv/sqrt(B*k)
    
    dnd=d./h;
    fnd=F./(h*sqrt(B*k));
    
    if i <= 3
    figure(1); hold on; 
        idx=zeros(101,1); ll = log(length(dnd)); jj=1; 
        
            for n = 0:ll/100:ll
        idx(jj) = 1*exp(n); jj=jj+1;
            end
        idx = round(idx);
     loglog(fnd(idx),dnd(idx),strcat('',syms(i)),'Color',rgb(7+ii,:),'MarkerSize',8);
    end
    
    
    % Now try and quickly estimate the stiffness
    inds=find(dnd<1 & dnd>0);
    k(:,1)=mean(fnd(inds)./dnd(inds));
    k(:,2)=std(fnd(inds)./dnd(inds));
    figure(3)
    errorbar(tau,k(:,1),k(:,2),strcat('',syms(i)),'Color',rgb(7+ii,:),'MarkerSize',10);
    set(gca,'Yscale','log')
    set(gca,'Xscale','log')
    hold on 
    ii=ii+1;
end 


%% Now plot Finn's data
figure(2); hold on
xlabel('$\zeta_0/h$','Interpreter','Latex')
ylabel('$F/[h(B\rho g)^{1/2}]$','Interpreter','Latex')

load('LoadForce.mat')

% plotting points so that colour increases through roygbiv with increasing
% tau
figure(2)
loglog(x{6,1},y{6,1},'rv','MarkerSize',10,'MarkerFaceColor','r')
hold on
loglog(x{4,1},y{4,1},'^','Color',[255/255, 255/255, 0.0],'MarkerSize',10,'MarkerFaceColor','y')
loglog(x{7,1},y{7,1},'s','Color',[255/255, 127/255, 0.0],'MarkerSize',10)
loglog(x{8,1},y{8,1},'go','MarkerSize',10)
loglog(x{5,1},y{5,1}, 'b<','MarkerSize',10)
loglog(x{2,1},y{2,1},'pk','Markersize',10,'MarkerFaceColor','k')

xvals=logspace(0,1.5,10);
loglog(xvals,xvals./8,'--k','LineWidth',2)

inpt=load('ForceLawTau=0.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k-','LineWidth',2)

set(gca,'ticklength',2*get(gca,'ticklength'))

axis([0.3 10^3.3 0.03 1e2])
box on
xlabel('${\cal F}=F/(h(B\rho g)^{1/2})$','Interpreter','LaTex')
ylabel('$\delta = \zeta_0/h$','Interpreter','LaTex')
set(gca,'Yscale','log')
set(gca,'Xscale','log')
hold off


%% Would also like to plot the value of the stiffness K_1 versus tau if possible

stiffnessvec=zeros(5,3);
tauvals=[1.8e-3; 3.76e-3; 4.35e-3; 1.72e-3; 2.63e-2];
stiffnessvec(:,1)=tauvals;

inds=find(y{6,1}<1 & y{6,1}>0);
stiffnessvec(1,2)=mean(x{6,1}(inds)./y{6,1}(inds));
stiffnessvec(1,3)=std(x{6,1}(inds)./y{6,1}(inds));

inds=find(y{7,1}<1 & y{7,1}>0);
stiffnessvec(2,2)=mean(x{7,1}(inds)./y{7,1}(inds));
stiffnessvec(2,3)=std(x{7,1}(inds)./y{7,1}(inds));

inds=find(y{4,1}<1 & y{4,1}>0);
stiffnessvec(3,2)=mean(x{4,1}(inds)./y{4,1}(inds));
stiffnessvec(3,3)=std(x{4,1}(inds)./y{4,1}(inds));

inds=find(y{8,1}<1 & y{8,1}>0);
stiffnessvec(4,2)=mean(x{8,1}(inds)./y{8,1}(inds));
stiffnessvec(4,3)=std(x{8,1}(inds)./y{8,1}(inds));

inds=find(y{5,1}<1 & y{5,1}>0);
stiffnessvec(5,2)=mean(x{5,1}(inds)./y{5,1}(inds));
stiffnessvec(5,3)=std(x{5,1}(inds)./y{5,1}(inds));

% Quick check of whether fits are reasonable

testxs=logspace(-2,0,10);

figure(3); hold on
errorbar(stiffnessvec(1,1),stiffnessvec(1,2),stiffnessvec(1,3),'rv','MarkerSize',10,'MarkerFace','auto')
errorbar(stiffnessvec(2,1),stiffnessvec(2,2),stiffnessvec(2,3),'s','Color',[255/255, 127/255, 0.0],'MarkerSize',10)
errorbar(stiffnessvec(3,1),stiffnessvec(3,2),stiffnessvec(3,3),'^','Color',[255/255, 255/255, 0.0],'MarkerSize',10,'MarkerFace','auto')

tauvals=logspace(-4,2,100);
k1vals=2*pi*sqrt(tauvals.^2-4)./atanh(sqrt(1-4./tauvals.^2));
loglog(tauvals,k1vals,'k-','LineWidth',1.5)
xlabel('$\tau$','interpreter','latex')
ylabel('$K_1$','interpreter','latex')
box on
set(gca,'ticklength',2*get(gca,'ticklength'))
axis([1e-3 100 4 2e2])
set(gca,'Yscale','log')
set(gca,'Xscale','log')
ax.YTick = [5, 10, 20, 50];


hold off

figure(1) % replot numerics over exp data for clarity
inpt=load('ForceLawTau=0.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k-')

inpt=load('ForceLawTau=1.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k.-.')

inpt=load('ForceLawTau=5.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k--')

inpt=load('ForceLawTau=10.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k:')

inpt=load('ForceLawTau=33.txt');
d=inpt(:,1);F=inpt(:,2);
loglog(F,d,'k-','LineWidth',1.25)
