%% plot delta_c/h vs tau

% load num & exp data
load('delta_ExpGamma22.mat') % tau; delta_c/h; error on delta_c/h
load('delta_ExpGamma72.mat') % tau; delta_c/h; error on delta_c/h
load('Num_Det_Method.mat'); Num_Det = sum2;  % tau; N_onset; delta_c
load('delta_scaling.mat')   % tau; delta_c

load('Indent_PVS_Feb2017.mat')  % h (mum); tau; delta_c; err; N_onset 

% plot data
figure; hold on
errorbar(delta_ExpGamma72(:,1),delta_ExpGamma72(:,2),delta_ExpGamma72(:,3),'ro','MarkerSize',10,'MarkerFaceColor','auto')
errorbar(delta_ExpGamma22(:,1),delta_ExpGamma22(:,2),delta_ExpGamma22(:,3),'bv','MarkerSize',10,'MarkerFaceColor','auto')
errorbar(Indent_PVS_Feb2017(:,2),Indent_PVS_Feb2017(:,3),Indent_PVS_Feb2017(:,4),'gsq','MarkerSize',10,'MarkerFaceColor','auto')
plot(Num_Det(:,1),Num_Det(:,3),'x')
plot(scaling(:,1),scaling(:,2),'--','LineWidth',1.5)


% format figure
set(gca,'xscale','log')
set(gca,'yscale','log')
ylim([5 500])
xlim([1e-2 1e2])
xlabel('$\tau$','Interpreter','Latex')
ylabel('$\delta_{c}$','Interpreter','Latex')
legend('Exp \gamma_{lv} = 72 mN/m','Exp \gamma_{lv} = 22 mN/m','Exp PVS','Numerics','Asymptote','Location','northwest')
box on
set(gca,'FontName','Times New Roman','Fontsize', 18);