%% Here we want to just focus on small displacements and check that all is fine 

close all;clear all;

load poking_profiles' D50-1_Load3_h5.mat'

% Plot Normalised height vs radial distance scaled by elasto-gravity length
lg = 41.3e-3; % obtained from table 1
figure(2); hold on

plot(x{7,1}(1:5:end)*1e-2/lg,y{7,1}(1:5:end),'v','Color',rgb(7,:),'MarkerSize',10)
plot(x{6,1}(1:5:end)*1e-2/lg,y{6,1}(1:5:end),'d','Color',rgb(6,:),'MarkerSize',10)
plot(x{5,1}(1:5:end)*1e-2/lg,y{5,1}(1:5:end),'s','Color',rgb(5,:),'MarkerSize',10)
plot(x{4,1}(1:5:end)*1e-2/lg,y{4,1}(1:5:end),'x','Color',rgb(4,:),'MarkerSize',10)
plot(x{3,1}(1:5:end)*1e-2/lg,y{3,1}(1:5:end),'*','Color',rgb(3,:),'MarkerSize',10)
plot(x{2,1}(1:5:end)*1e-2/lg,y{2,1}(1:5:end),'o','Color',rgb(2,:),'MarkerSize',10)
plot(x{1,1}(1:5:end)*1e-2/lg,y{1,1}(1:5:end),'+','Color',rgb(1,:),'MarkerSize',10)

% Now plot the theoretical prediction
i=sqrt(-1);
lm=-i;
lp=i;

xvals=linspace(0,10,1e4);
yvals=2./log(lm/lp)*(besselk(0,sqrt(lp)*xvals)-besselk(0,sqrt(lm)*xvals));

figure(2)
hold on
plot(xvals,yvals,'k-','linewidth',2)
plot(-xvals,yvals,'k-','linewidth',2)
axis([-5 5 -1.1 0.1])
set(gca,'ticklength',2*get(gca,'ticklength'));
ax = gca;
ax.XTick = [-5,-2.5,0,2.5,5];
box on

xlabel('$r/\ell_g$','Interpreter','Latex')
ylabel('$\zeta/\zeta_0$','Interpreter','Latex')
legend('\delta = 0.21','\delta = 0.38','\delta = 0.52','\delta = 0.63','\delta = 0.73','\delta = 0.81','\delta = 0.93','Location','SouthEast')

hold off