function dat=getScans(date)

%% On resonance:

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%     % date = '150618';
% names = {...
%     % signal poln (H):
%     strcat(date,'_scan_locked_sp_8765_p_17000mW_HWP21_BBO_82_trial_13.txt'),...
%     % control poln (V):
%     strcat(date,'_scan_locked_sp_8765_p_17000mW_HWP21_BBO_82_trial_12.txt')...
%     };
% p = {'H','V'};
%     
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
%     % date = '150622';
% names = {...
%     % signal poln (H):
%     strcat(date,'_scan_locked_sp_8765_p_17000mW_HWP21_BBO_82_trial_1.txt'),...
%     % control poln (V):
%     strcat(date,'_scan_locked_sp_8765_p_17000mW_HWP21_BBO_82_trial_2.txt')
%     };
% p = {'H','V'};
% 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% 
if strcmp( date ,'150624');
names = {...
    % signal poln (H):
    strcat(date,'_scan_locked_sp_8890_p_8100mW_HWP21_BBO_82_trial_2.txt'),...
    % control poln (V):
    strcat(date,'_scan_locked_sp_8890_p_8100mW_HWP21_BBO_82_trial_3.txt')...
    };
p = {'H','V'};
elseif strcmp(date,'150703');
    names = {...
        '150703_scan_locked_sp_8830_p_0000mW_HWP21_BBO_82_trial_6.txt',...
        '150703_scan_locked_sp_8830_p_0500mW_HWP21_BBO_82_trial_8.txt',...
        '150703_scan_locked_sp_8830_p_1000mW_HWP21_BBO_82_trial_7.txt',...
        '150703_scan_locked_sp_8830_p_1500mW_HWP21_BBO_82_trial_9.txt',...
        '150703_scan_locked_sp_8830_p_2000mW_HWP21_BBO_82_trial_10.txt',...
        '150703_scan_locked_sp_8830_p_4600mW_HWP21_BBO_82_trial_4.txt',...
        '150703_scan_locked_sp_8830_p_5800mW_HWP21_BBO_82_trial_3.txt',...
        '150703_scan_locked_sp_8830_p_6700mW_HWP21_BBO_82_trial_2.txt',...
        '150703_scan_locked_sp_8830_p_7700mW_HWP21_BBO_82_trial_1.txt'...
        };
    p = 'H';
elseif strcmp(date,'150706')
    names = flip({...
        '150706_scan_locked_sp_4060_p_6700mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_4500_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_5010_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_5500_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_6010_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_6500_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_7000_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_7500_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_8000_p_6300mW_HWP21_BBO_82_temprun1.txt',...
        '150706_scan_locked_sp_8500_p_6300mW_HWP21_BBO_82_temprun1.txt'...
%         '150706_scan_locked_sp_8830_p_6500mW_HWP21_BBO_82_check1.txt'...
        });
    p = 'H';
end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
for i=1:length(names);
    trial=strcat('scan',num2str(i));
    fname = strcat(date,'/',names{i});
    [f,s]=openScanData(fname);
    dat.(trial).name=fname;
    dat.(trial).freq=-f;
    dat.(trial).sig=s;
    dat.(trial).laser='TiSa';
    dat.(trial).params = propertyFinder(fname);
    if length(p) == 1
        dat.(trial).poln = p;
    elseif length(p) == length(names)
        dat.(trial).poln = p{i};
    end;
end;

end


function output = propertyFinder(filename)

%this assumes the data comes in the standard way
%150330_scan_sp_73_p_5_7mW_HWP122_BBO_103_trial_1.txt

p_location = strfind(filename, '_p_');
sp_location = strfind(filename, '_sp_');
mW_HWP_location = strfind(filename, 'mW_HWP');
BBO_location = strfind(filename, '_BBO_');
% trial_location = strfind(filename, '_trial_');
output.temp_set_point = str2num(filename(sp_location+4:p_location-1));
output.pumping_power = str2num(filename(p_location+3:mW_HWP_location-1));
output.HWP = str2num(filename(mW_HWP_location+6:BBO_location-1));
% output.BBO_temp = str2num(filename(BBO_location+5:trial_location-1));
% output.trial_no = str2num(filename(trial_location+7:end-3));

end