 %% execute this to import global constants into workspace
% cavStruc contains parameters for current version of cavity experiment
function constants_150710()
global omega0 DeltaG D2dip mCs
global c q e0 hbar kB
global cavStruc
% caesium physical constants *)
omega0 = 2*pi*(351.7257185*10^12);%(*D2 transition, s^-1*)
DeltaG = 2*pi*(9.192632*10^9);%(*ground state splitting, s^-1*)
D2dip  = (3.7971*10^-29);%(*effective dipole moment = ( |<J=1/2||er||J'=3/2>|^2 ) *)
mCs    = 2.20694650*10^-25;%(*Atomic mass, kg *)
% (*universal physical constants *)
c    = 2.99792458*10^8;
q    = 1.602176462*10^-19;
e0   = 8.854187817*10^-12;
hbar = 1.054571596*10^-34;
kB   = 1.3806503*10^-23;
% Cavity reflectivities and transmissions
cavStruc.Lcs = 2*0.01;%(*double passed Cs cell length, m*)
cavStruc.M = 2;%cavity order
cavStruc.LtrialM = 2*pi*c*(cavStruc.M+1/2)/(2*DeltaG);
cavStruc.Lout = cavStruc.LtrialM-cavStruc.Lcs;
cavStruc.L0 = 2*10^-3;%estimate of distance between input and output mirrors
% cavStruc.Eta_Cav = 0.97;
% measured cavity parameters, Horizontal => signal
cavStruc.R1.H  = sqrt(70/95);%(*amplitude reflection*)
cavStruc.R2.H  = sqrt(1-48/220);
cavStruc.vis.H = 0.88;
cavStruc.Tr_leak.H = sqrt(0.07);
cavStruc.Eta_Cav.H = sqrt(30/135)/cavStruc.R2.H;
% measured cavity parameters, Vertical => control
cavStruc.R1.V  = sqrt(53/91);%(*amplitude reflection*)
cavStruc.R2.V  = sqrt(1-77/220);
cavStruc.vis.V = 0.75;
cavStruc.Tr_leak.V = sqrt(0.20);
cavStruc.Eta_Cav.V = sqrt(47/135)/cavStruc.R2.V;
% extracted cavity parameters *)
HV={'H','V'};
for i=1:2
    poln = HV{i};
    cavStruc.Tr_Calc.(poln)    = ...
        sqrt((1-cavStruc.R1.(poln)^2)*(1-cavStruc.R2.(poln)^2));
    cavStruc.Zeta0_Calc.(poln) = ...
        f1(sqrt(f1(cavStruc.vis.(poln))));
    cavStruc.Zeta0_Infr.(poln) = ...
        cavStruc.R1.(poln) * cavStruc.R2.(poln) * cavStruc.Eta_Cav.(poln);
end;

end

function y=f1(x)
y=(1-x)/(1+x);
end