function [complex_n, od_Fict] = complexN_hfs_mod(Delta, n, etaPump, widths)
% od_Fict numbers not checked... 150725
% global omega0 
% global DeltaG D2dip e0 hbar
% global c cavStruc

% omega0 = 2*pi*(351.7257185*10^12);%(*D2 transition, s^-1*)
DeltaG = 2*pi*(9.192632*10^9);%(*ground state splitting, s^-1*)
D2dip  = (3.7971*10^-29);%(*effective dipole moment = ( |<J=1/2||er||J'=3/2>|^2 ) *)
e0   = 8.854187817*10^-12;
hbar = 1.054571596*10^-34;


% [S3,S4] = cleb();
sigmaGauss  = widths.sigmaDopp;
gammaCauchy = widths.gammaP;
shift = widths.shiftP/(2*pi*1e9);

x = Delta/sigmaGauss;
dx = (x(end)-x(1))/(length(x)-1);
a = gammaCauchy/sigmaGauss;
gauss = ShapeFn_Gaussian(x,1);

foffset = -(0.18844+0.15121/2) - shift;%DLC locked to crossover resonance
% Blue Transition F=3
% Delta1=Delta;
s3f = (7/(7+9))*[5/14, 3/8, 15/56];
d3f = ((foffset - [-0.33964, -0.18844, +0.012815])*2*pi*10^9)/sigmaGauss;

% Red Transition F=4
% Delta2=Delta+DeltaG;
s4f = (9/(7+9))*[7/72, 7/24, 11/18];
d4f = (DeltaG + (foffset - [-0.18844, +0.012815, +0.26381])*2*pi*10^9)/sigmaGauss;

xl3 = zeros(1,length(Delta));
xl4 = xl3;%zeros(1,length(Delta));
for i = 1:3
    x3 = ShapeFn_Cauchy( (x + d3f(i)) , a);
    x4 = ShapeFn_Cauchy( (x + d4f(i)) , a);
    
    xl3 = xl3+ x3.*(...
        -(x + d3f(i))/a...
        +1i...
        )*s3f(i)*((1-etaPump)/2);
    xl4 = xl4 + x4.*(...
        -(x+d4f(i))/a...
        +1i...
        )*s4f(i)*((1+etaPump)/2);
end;
y = xl3 + xl4;
z = (pi/sigmaGauss)*convft(y,gauss)*dx;
chi = (2/3)*z*(n/(e0*hbar)) * (D2dip^2);
complex_n = 1+0.5*chi;%ComplexN(chi);

od_Fict = 0;

% figure;
% subplot(2,1,1);plot(Delta/(2*pi*10^9),real(chi));
% xlabel('Detuning [GHz]');ylabel('\chi^{,}');xlim([-20,30]);
% subplot(2,1,2);plot(Delta/(2*pi*10^9),imag(chi));
% xlabel('Detuning [GHz]');ylabel('\chi^{,,}');xlim([-20,30]);
end


function y = ShapeFn_Gaussian(x,sigma)
y = (1/(sigma*sqrt(2*pi))) * exp(-0.5*(x/sigma).^2);
end

function y=ShapeFn_Cauchy(x,gamma)
y = (1/(gamma*pi)) * (1+(x/gamma).^2).^-1;
end

function z = convft(x,y)
X = fft(x);
Y = fft(y);
Z = X.*Y;
z = fftshift(ifft(Z));
end