function [int,amp,OD] = cavityTransmission(Delta,Tr0,zeta0,phi0,complexN)
global omega0 DeltaG% D2dip mCs
global c% q e0 hbar kB
global cavStruc
[~,ind0] = min(abs(Delta+DeltaG));

alpha = imag(complexN);
kappa = real(complexN);

zeta = zeta0 * exp( -(omega0+Delta).*alpha*(cavStruc.Lcs)/c );
phi  = phi0 + ( (omega0+Delta).*kappa*(cavStruc.Lcs)/c );%phi0 also frequency dependant

% int.Lower = (Tr0^2) * (1+zeta).^-2;
% int.Upper = (Tr0^2) * (1-zeta).^-2;


int.trans = (Tr0^2) ./ ( (1-zeta).^2 + 4*zeta.*sin(phi/2).^2 );
amp.trans = Tr0./(1-zeta.*exp(1i*phi));

OD = 0.5*omega0*alpha(ind0)*(cavStruc.Lcs)/c ;