function FitArr = alignSignalResonance(Delta,Tc_PB,Tc_DB,Tc_res,Eta_pump,pShift,LossCorrection,poln,laser,target)
%  Note that the length correction applies a correction over +/- 1 lambda
%  about extracted length from off resonant data taken 150508 plus dLength.
% 150701:  length updated to fit data from 150618 & 150624, verified on 150703.
% X = Delta/(2*pi*10^9);
% global dL0
dL0 = (-3.3*10^-3) ;%+ dLength;

const.Tc_PB = Tc_PB;
const.Tc_DB = Tc_DB;
const.Tc_res= Tc_res;
const.Eta_pump=Eta_pump;
const.LossCorrection= LossCorrection;
const.poln = poln;
const.laser = laser;
const.shift = pShift;

% params.dL = 0;
% estimates = [...
% params.dL,-1,1;...
% ];
% est.centre = 0;%estimates(:,1);
est.lower = -1;%estimates(:,2);
est.upper = 1;%estimates(:,3);

FitArr = fmin(est,Delta,const,target,dL0);

% figure;plot(X,FitArr.Y);
end
function fit = fmin(est,Delta,const,target,dL0)
fn = @(x)costFn(x,Delta,const,target,dL0);
[fit.x,fit.fval,fit.exitflag,fit.output] = fminbnd(fn,est.lower,est.upper);
global omega0 c;% dL0
fit.dLength = dL0+(2*pi*c/omega0)*fit.x;
y = MainHandler(Delta,...
    const.Tc_PB,const.Tc_DB,const.Tc_res,const.Eta_pump,...
    fit.dLength,...
    const.shift,...
    const.LossCorrection,const.poln);
if strcmp(const.laser,'DLC')
    fit.Y = y.out;
elseif strcmp(const.laser,'TiSa')
    fit.Y = y.corr;
else
    fit.Y = y;
end;
fit.OD_fict = y.OD_fict;
fit.OD_meas = y.OD_meas;
fit.amp = y.amp;
end
function cost = costFn(x,Delta,const,target,dL0)
global omega0 c;% dL0
dLength = dL0+(2*pi*c/omega0)*x;
y = MainHandler(Delta,...
    const.Tc_PB,const.Tc_DB,const.Tc_res,const.Eta_pump,...
    dLength,...
    const.shift,...
    const.LossCorrection,const.poln);
[~,ind6]=min(abs( (Delta/(2*pi*10^9))-target ) );
if strcmp(const.laser,'TiSa')
    Y = y.corr;
else
    Y = y.out;
end;
cost = -Y(ind6);
end