function n=SteckNumDensity(T)
global omega0 DeltaG D2dip mCs
global c q e0 hbar kB

%% From Steck:

tC=T-273.15;

if tC>25;
    logP = +8.22127 - ((4006.048)./T) - 0.00060194*T - 0.19623*log10(T);
else
    logP = -219.482 + ((1088.676)./T) - 0.08336185*T + 94.88752*log10(T);
end;

p = 133.322*(10.^logP);

n = (p./T)/kB;

%% From ElecSus_1.0.1:

%     if T<301.65
%         p=10.0^(4.711-3999./T);
%     else
%         p=10.0^(8.232-4062./T-1.3359*log10(T));
%     end
%     n=101325.0*p/(kB*T);