%% MainHandler generates the cavity response function
% response array calculated on an array of frequencies, Delta
% given cavity parameters, temperatures etc...
% returns structure :
%   "y.out" is bare cavity response - eg CW response
%   "y.Env" is structure for envelope of bare cavity response
%   "y.corr" includes convolution with gaussian pulse with width given in
%       width.m

function y = MainHandler(Delta,Tc_PB,Tc_DB,Tc_res,Eta_pump,dLength,pShift,LossCorrection,poln)
constants_150710;

global omega0% DeltaG D2dip mCs
global c% q e0 hbar kB
global cavStruc
global pulseBandwidth

wid_PB  = Tc_PB;
wid_DB  = Tc_DB;
TempK_Res = Tc_res+273.15;
etaPump   = Eta_pump;
dL        = dLength;

width.gammaP = wid_PB*2*pi*1e9;
width.shiftP = pShift*2*pi*1e9;
width.sigmaDopp = wid_DB*2*pi*1e9;
% pulseBandwidth = 0.5;%GHz
width.sigmaPulse = (pulseBandwidth/(2*sqrt(2*log(2))))*2*pi*10^9;
% width = widths(TempC_DB+273,TempC_PB+273);
num   = SteckNumDensity(TempK_Res);

gaussianPulse = ShapeFn_Gaussian(Delta,width.sigmaPulse); 

% Tr0   = cavStruc.Tr_leak.(poln);
Tr0   = cavStruc.Tr_Calc.(poln);
% zeta0 = LossCorrection*cavStruc.Zeta0_Calc.(poln);
zeta0 = LossCorrection;%*cavStruc.Zeta0_Infr.(poln);
phi0  = ((omega0+Delta)*(dL+cavStruc.Lout)/c);

n_noAtoms = ones(size(Delta));
if TempK_Res ==0
complexRI = n_noAtoms;
od_fict = 0;
else
[complexRI,od_fict] = complexN_hfs_mod(Delta,num,etaPump,width);
end
% [complexRI,od_fict] = complexN_hfs_mod_FaddSGJ(Delta,num,etaPump,width);

[intensity,amplitude,OD_meas] = ...
    cavityTransmission(Delta,Tr0,zeta0,phi0,complexRI);

y.RI = complexRI;
y.out = intensity.trans;
% y.Env.Top = intensity.Upper;
% y.Env.Bottom = intensity.Lower;
y.amp = amplitude;
y.OD_fict = od_fict;
y.OD_meas = OD_meas;

dDelta = (Delta(end)-Delta(1))/(length(Delta)-1);

% y.corr = conv(intensity.trans,gaussianPulse,'same')*dDelta;
y.corr = convft(intensity.trans,gaussianPulse)*dDelta;


end


function y = ShapeFn_Gaussian(x,sigma)
y = (1/(sigma*sqrt(2*pi))) * exp(-0.5*(x/sigma).^2);
end

function z = convft(x,y)
X = fft(x);
Y = fft(y);
Z = X.*Y;
z = fftshift(ifft(Z));
end

