%% iterate over fitting function

function fitArr = IterFit_align_postOd(dat,target,x,boolPlot,boolFit,method,numpoints,range,boolAdjLoss)
% x = [p d T shift eta]
constants_150710;
global cavStruc;

% numpoints =1e3;
freqMin = -range/2;%-30
freqMax = +range/2;%+30
X = linspace(freqMin,freqMax,numpoints);
Delta = X*2*pi*10^9;

% global estimZ;

poln = dat.poln;
v = dat.sig;
v = (max(v)-min(v))/(max(v)+min(v));
v = ((1-v)/(1+v))^2;
v = (1-v)/(1+v);
if boolAdjLoss
    estimZ = mean([v cavStruc.Zeta0_Calc.(poln) cavStruc.Zeta0_Infr.(poln)]);
elseif ~boolAdjLoss
    estimZ = mean([cavStruc.Zeta0_Calc.(poln) cavStruc.Zeta0_Infr.(poln)]);
end;

params.Tc_P  = x(1);% pressure width GHz
params.Tc_D   = x(2);% doppler width GHz
params.Tc_res = x(3);% reservoir temperature degC
params.pShift = x(4);% pressure shift GHz
params.Eta_pump = x(5);% pumping efficiency
params.LossAppr = estimZ;
params.sf   = x(6);%
params.Background = x(7);%0.01;%
params.pulseBandwidth = x(8);

% [Pr Do Tr Sh Et Lo Sf Bg]
estimates = [...
%     params.Tc_P, 0.01, 0.3;...
%     params.Tc_D, 0.01, 0.3;...
    params.Tc_res, params.Tc_res-20, params.Tc_res+20;...
%     params.pShift, -0.1, 0;...
    params.Eta_pump, 0.5, 1;...
%     params.LossAppr, 0.5*estimZ, 2.*estimZ;...
    params.sf, 0.1, 1;...
    params.Background,0,1;...
%     params.pulseBandwidth, 0.2, 1.2;...
    ];

est.centre = estimates(:,1);
est.lower = estimates(:,2);
est.upper = estimates(:,3);

% tic
fitArr = fmin(Delta,dat,target,est,poln,boolPlot,boolFit,method,params);
fitArr.loss = estimZ;
% toc

end
            
%%  fitting function

function fit = fmin(Delta,dat,target,estimates,poln,boolPlot,boolFit,method,params)
% tic
% points
freq = dat.freq;
sig  = dat.sig;
sig = sig/max(sig);
pks = dat.peakLocs;

% add random noise each time:
freqError = 0;%0.01;%0.05;%GHz
sigError = 0;%0.01*min(sig);% frac
freq= freq+freqError*randn(size(freq));
sig = sig+sigError*randn(size(sig));

lenTrial = length(freq);
ind = zeros(lenTrial,1);
nrPk = ones(lenTrial,1)/3;
for i = 1:lenTrial;
    [~,ind(i)]=min(abs( (Delta/(2*pi*10^9))-freq(i) ) );
    % check if near to a peak:
    for j = 1:length(pks)
        if (abs(freq(i)-0)<2.5)
            nrPk(i) = 1;
            break;
        end;
        if (abs(freq(i)+8.5892)<3)
            nrPk(i) = 1;
            break;
        end;
        if (abs(freq(i)-pks(j))<1.5)
            nrPk(i) = 2/3;
            break;
        end;
    end;
end;

if boolFit
    tic
    disp('fitting...')
    if strcmp(method,'SA');
        f = @(x)costFn_SA(x,Delta,ind,sig,target,poln,nrPk,params);
        [x,fval,exitflag,output] = ...
            simulannealbnd(f,estimates.centre,estimates.lower,estimates.upper);
        fit.params = x;
        fit.fval = fval;
        fit.exitflag = exitflag;
        fit.out = output;
    elseif strcmp(method,'GA')
        f = @(x)costFn_SA(x,Delta,ind,sig,target,poln,nrPk,params); 
        opts = gaoptimset('TolFun',1e-10,...
        'PlotFcns',{@gaplotbestf,@gaplotstopping},...
        'PopulationSize',200);
        [x,fval,exitflag,output] = ...
            ga(f,length(estimates.centre),[],[],[],[],...
            estimates.lower,estimates.upper,...%
            [],opts);
        fit.params = x;
        fit.fval = fval;
        fit.exitflag = exitflag;
        fit.out = output;
    else
        f = @(x)costFn_lsq(x,Delta,ind,sig,target,poln,nrPk,params);
        if strcmp(method,'TRR');
        options = optimoptions(@lsqnonlin,...
            'Algorithm','trust-region-reflective',...
            'TolFun',1e-10,...%1e-6 default
            'TolX',1e-10,...%1e-6 default
            'MaxFunEvals',8000);%100*numParams=800 default
            [x,resnorm,~,exitflag,output] = ...
                lsqnonlin(f,estimates.centre,estimates.lower,estimates.upper,options);
        elseif strcmp(method,'L-M');
        options = optimoptions(@lsqnonlin,...
            'Algorithm','levenberg-marquardt',...
            'TolFun',1e-10,...%1e-6 default
            'TolX',1e-10,...%1e-6 default
            'MaxFunEvals',8000);%200*numParams=1600 default
            [x,resnorm,~,exitflag,output] = ...
                lsqnonlin(f,estimates.centre,[],[],options);
        end;
        fit.params = x;
        fit.ssy = resnorm;
%         fit.residual = residual;
        fit.exitflag = exitflag;
        fit.out = output;
    end;
toc
elseif ~boolFit
    x = estimates.centre;
    fit.params = x;
end;
%%
ttmp = x(1)+273.15;
wid = widths(ttmp,ttmp);
% [Pr Do Tr Sh Et Lo Sf Bg]
% global omega0 c;
% global estimZ
Tc_PB = wid.gammaP/(2*pi*1e9);%0.5*0.0052227+x(1);
Tc_DB = wid.sigmaDopp/(2*pi*1e9);%x(2);
Tc_res = x(1);
pShift = wid.shiftP/(2*pi*1e9);%x(4);
Eta_pump = x(2);
% dLength = 0;
LossCorrection = params.LossAppr;
sf = params.sf;%x(3);%
bg = params.Background*min(sig);%x(4);%

% global pulseBandwidth
% pulseBandwidth = x(8);

SIG = sf*(sig-bg);

ystruc = alignSignalResonance(Delta,...
    Tc_PB, Tc_DB, Tc_res,...
    Eta_pump, pShift, ...
    LossCorrection,poln,'TiSa',target);
y = ystruc.Y;%/sf+bg;
fit.model.freq=Delta/(2*pi*1e9);
fit.model.sig=y;
Y = reshape(y(ind),lenTrial,1);

fit.theory = Y;

% if ~boolFit
    residual = SIG-Y;
    fit.residual = residual;
    fit.ssRes = sum(residual.^2);
% end;


if boolPlot % if fit.ssRes<=1
    disp('plotting...')
    
    figure;
    xlimits = [-15 15];
    ylimits = [0 0.6];

%     subplot(3,1,[1,2]);
%     title(strcat('params: ',num2str(transpose(x))));
    hold all;
    plot(freq,SIG,'o')
    plot(Delta/(2*pi*10^9),y,'r');
%     plot(freq, 1.05*max(SIG)*nrPk);
    xlim(xlimits);
    ylim(ylimits)
    plot([1 1]*0,ylimits,':k');
    plot([1 1]*(-8.9286),ylimits,':k');    
    ylabel('Signal (Arb. units)');
    hold off;
%     subplot(3,1,3)
%     title(['ssRes = ',num2str(fit.ssRes)])
%     hold all;
%     plot(freq,residual);
%     plot(xlimits,[0 0],':')
%     hold off;
%     xlim(xlimits)
    xlabel('Detuning (GHz)');
%     ylabel('Residuals');
end;

% toc
end


%% model and cost function (LSQ NonLin)

function cost = costFn_lsq(x, Delta, ind, sig, target, poln, nrPk,params)
% global omega0 c

ttmp = x(1)+273.15;
wid = widths(ttmp,ttmp);
% [Pr Do Tr Sh Et Lo Sf Bg]
% global omega0 c;
% global estimZ
Tc_PB = wid.gammaP/(2*pi*1e9);%0.5*0.0052227+x(1);
Tc_DB = wid.sigmaDopp/(2*pi*1e9);%x(2);
Tc_res = x(1);
shift = wid.shiftP/(2*pi*1e9);%x(4);
Eta_pump = x(2);
% dLength = 0;
LossCorrection = params.LossAppr;
sf = params.sf;%x(3);%
bg = params.Background*min(sig);%x(4);%

% global pulseBandwidth
% pulseBandwidth = x(9);

SIG = sig;%sf*(sig-bg);

% ystruc = MainHandler(Delta,...
%     Tc_PB, Tc_DB, Tc_res,...
%     Eta_pump, dLength, LossCorrection,poln);
% y=ystruc.corr;

ystruc = alignSignalResonance(Delta,...
    Tc_PB, Tc_DB, Tc_res,...
    Eta_pump, shift,...
    LossCorrection,poln,'TiSa',target);

y=ystruc.Y/sf+bg;

modelSig  = reshape(y(ind),length(SIG),1);

weight = nrPk;%1;%sqrt(SIG);
cost = weight.*abs(SIG-modelSig);
end

%% model and cost function (Sim Anneal)

function cost = costFn_SA(x, Delta, ind, sig, target, poln, nrPk, params)
% global omega0 c

ttmp = x(1)+273.15;
wid = widths(ttmp,ttmp);
% [Pr Do Tr Sh Et Lo Sf Bg]
% global omega0 c;
% global estimZ
Tc_PB = wid.gammaP/(2*pi*1e9);%0.5*0.0052227+x(1);
Tc_DB = wid.sigmaDopp/(2*pi*1e9);%x(2);
Tc_res = x(1);
shift = wid.shiftP/(2*pi*1e9);%x(4);
Eta_pump = x(2);
% dLength = 0;
LossCorrection = params.LossAppr;
sf = params.sf;%x(3);%
bg = params.Background*min(sig);%x(4);%

% global pulseBandwidth
% pulseBandwidth = x(7);

SIG = sig;%sf*(sig-bg);

% ystruc = MainHandler(Delta,...
%     Tc_PB, Tc_DB, Tc_res,...
%     Eta_pump, dLength, LossCorrection,poln);
% y=ystruc.corr;

ystruc = alignSignalResonance(Delta,...
    Tc_PB, Tc_DB, Tc_res,...
    Eta_pump, shift,...
    LossCorrection,poln,'TiSa',target);

y=ystruc.Y/sf+bg;

modelSig  = reshape(y(ind),length(SIG),1);

weight = nrPk;%1;%sqrt(SIG);
cost = weight.*(SIG-modelSig);
cost = sum(cost.^2);
end