constants_150710;
% global omega0 DeltaG D2dip mCs
% global c q e0 hbar kB
% global cavStruc
global pulseBandwidth
pulseBandwidth = 0.5;

% array of finely spaced frequencies over large range for better
% approximation of integrals
numpoints = 0.1*10^6;
freqMin = -50;
freqMax = +50;
X = linspace(freqMin,freqMax,numpoints);
Delta = X*2*pi*10^9;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

poln='H';
laser = 'TiSa';
target = 6;
% % Tp = 90.;
% % Td = 100;
% % Tr = 101;%
% EtP = 0.8;% function of temperature, too
% dL = 0;%This is additionally added onto the length extracted from the far off resonant scans 150706
% LossCorr = 1.;%Loss now defined with measurements from 150710

clc
load('fit_avgs_150727');%params from OD measurements
avg=avgs150727;

%pressure broadening
C1 = (avg.gP).*[1,1,1,1,1,.506,...
    .1,.066,.1,.1]; 
% Doppler broadening
C2 = (avg.sD).*[1,1,1,1,1,1,...
    .1,.311,.1,0.7];
% reservoir temperature
C3 = avg.Tr-[2.5,2.5,1.5,-3.0,-6.0,-14.0,...
    -18.75,-22.5,-23,-25];
% pressure shift
C4 = avg.Ps;
% pumping efficiency
C5 = [0.800,0.850,0.900,0.950,0.960,0.930,...
    0.930,0.930,.930,0.930];
% loss
C6 = [0.6644, 0.6644, 0.6644, 0.6646, 0.6645, 0.6647, 0.6645, 0.6644, 0.6642, 0.6646];

%% parameters for signal scans varying temperature

load('ga_finvals');
t1=fin.t;
w1=widths(t1+273.15,t1+273.15);
C1_tr1 = w1.gammaP/(2*pi*1e9);
C2_tr1 = w1.sigmaDopp/(2*pi*1e9);
C3_tr1 = t1;
C4_tr1 = w1.shiftP/(2*pi*1e9);
C5_tr1 = fin.e;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%
t=linspace(85,40,10);


blankMat = zeros(length(X),length(t));
X1=blankMat;
Y1=blankMat;
Z1=blankMat;

cutoff = 5;
for i=1:cutoff
    Tp = C1_tr1(i);
    Td = C2_tr1(i);
    Tr = C3_tr1(i);
    EtP = C5_tr1(i);
    ShP = C4_tr1(i);
    LossCorr = C6(i);
    
    tic
    alignFit = alignSignalResonance(Delta,Tp,Td,Tr,EtP,ShP,LossCorr,poln,laser,target);
%     (Delta,Tc_PB,Tc_DB,Tc_res,Eta_pump,pShift,LossCorrection,poln,laser,target)
    toc
    z = alignFit.Y;
    
    X1(:,i) = X;
    Y1(:,i) = t(i)*ones(length(X),1);
    Y1_ex(:,i) = C3(i)*ones(length(X),1);
    Z1(:,i) = z;
end;

for i=cutoff+1:10
    Tp = C1(i);
    Td = C2(i);
    Tr = C3(i);
    EtP = C5(i);
    ShP = C4(i);
    LossCorr = C6(i);
    
    tic
    alignFit = alignSignalResonance(Delta,Tp,Td,Tr,EtP,ShP,LossCorr,poln,laser,target);
%     (Delta,Tc_PB,Tc_DB,Tc_res,Eta_pump,pShift,LossCorrection,poln,laser,target)
    toc
    z = alignFit.Y;
    
    X1(:,i) = X;
    Y1(:,i) = t(i)*ones(length(X),1);
    Y1_ex(:,i) = C3(i)*ones(length(X),1);
    Z1(:,i) = z;
end;
% %%
% figure;
% subplot(1,2,2)
% [C1,H1]=contourf(X1,Y1,Z1,10);
% set(H1,'LineColor','none');
% xlim([-1 1]*15)
% ylim([40 85])
% xlabel('Detuning (GHz)');
% ylabel('Reservoir Temperature ($^\circ$C)')
% axis square

%%
clearvars Dat fields
Dat = getScans('150706');
fields = fields(Dat);

blankMat = zeros(300,length(fields));
X2 = blankMat;
Y2 = blankMat;
Z2 = blankMat;

for i=1:length(fields);
    field=fields{i};
    x = Dat.(field).freq(:);
    z = Dat.(field).sig(:);
    z = z/max(z);
    z = 0.5*(z-0.52*min(z));
    y = Dat.(field).params.temp_set_point*ones(length(x),1)/100;
    
    X2(:,i) = x;
    Y2(:,i) = y;
    Y2_id(:,i) = t(i)*ones(length(X2),1);
    Y2_ex(:,i) = C3(i)*ones(length(X2),1);
    Z2(:,i) = z;
    clearvars x y z;
end
%%
% % figure;
% subplot(1,2,1);
% [C2,H2]=contourf(X2,Y2,Z2,10);
% set(H2,'LineStyle','none');
% xlim([-1 1]*15)
% ylim([40 85])
% xlabel('Detuning (GHz)');
% ylabel('Reservoir Temperature ($^\circ$C)')
% axis square

%%

xlimits = [-15 15];
[~,i0]=min(abs(X-xlimits(1)));
[~,i1]=min(abs(X-xlimits(2)));
step = 100;

% view([23,76])
% view([9,72])
% view([23,66])
vangle = [25,72];
opaE = 0.4;
opaF = 0.2;
hfac = 1.;

% set(0,'DefaultAxesBox','off');
figure;
% subplot(2,1,1)
hold all;
for i=1:cutoff
    plot3(X1(i0:step:i1,i),Y1_ex(i0:step:i1,i),Z1(i0:step:i1,i),'-r')
    plot3(X2(:,i),Y2_ex(:,i),Z2(:,i),'.b')
end;
for i=cutoff+1:10
    plot3(X1(i0:step:i1,i),Y1_ex(i0:step:i1,i),Z1(i0:step:i1,i),'--r')
    plot3(X2(:,i),Y2_ex(:,i),Z2(:,i),'.b')
end;
ranZ = 1.3*[0,max(max(Z1))];
ranY = [min(t),max(t)];
surf([1 1]*0,ranY,hfac*[ranZ;ranZ],...
    'EdgeColor','b','EdgeAlpha',opaE,...
    'FaceColor','b','FaceAlpha',opaF);
surf([1 1]*(-8.9286),ranY,hfac*[ranZ;ranZ],...
    'EdgeColor','b','EdgeAlpha',opaE,...
    'FaceColor','b','FaceAlpha',opaF);
surf([1 1]*(+6),ranY,hfac*[ranZ;ranZ],...
    'EdgeColor','r','EdgeAlpha',opaE,...
    'FaceColor','r','FaceAlpha',opaF);
hold off
xlim(xlimits)
ylim(ranY)
zlim(ranZ)
view(vangle)
xlabel('Detuning (GHz)','interpreter','tex');
% ylbl=sprintf('Reservoir Temperature (%cC)',char(176));
ylabel('Reservoir Temperature ($^{\circ}$C)');%ylbl,'interpreter','tex');%'Reservoir Temperature ({\circ}C)','interpreter','tex');%
zlabel('Cavity Transmission (Arb. units)','interpreter','tex');
% camproj('perspective')
% %%
% % subplot(2,1,2);
% figure;
% hold all;
% for i=1:length(t)
%     scatter3(X2(:,i),Y2(:,i),Z2(:,i),'.r')
% end;
% ranZ = 1.3*[0,max(max(Z2))];
% ranY = [min(t),max(t)];
% surf([1 1]*0,ranY,hfac*[ranZ;ranZ],...
%     'EdgeAlpha',0,...
%     'FaceColor','b','FaceAlpha',opaF);
% surf([1 1]*(-8.9286),ranY,hfac*[ranZ;ranZ],...
%     'EdgeAlpha',0,...
%     'FaceColor','b','FaceAlpha',opaF);
% surf([1 1]*(+6),ranY,hfac*[ranZ;ranZ],...
%     'EdgeAlpha',0,...
%     'FaceColor','r','FaceAlpha',opaF);
% hold off
% xlim(xlimits)
% ylim(ranY)
% zlim(ranZ)
% view(vangle)
% xlabel('Detuning [GHz]');
% ylabel('Reservoir Temperature [$^\circ$C]');
% camproj('perspective')
% % whitebg()
% set(0,'DefaultAxesBox','on');
% 
% %%
% num1 = i1-i0+1;
% tmpX = zeros(10*num1);
% tmpZ = zeros(10*num1);
% tmpY = zeros(10*num1);
% for i=1:length(t)
%     tmpX1(i*num1:(i+1)*num1-1) = X1(i0:i1,i);
%     tmpY1(i*num1:(i+1)*num1-1) = Y1(i0:i1,i);
%     tmpZ1(i*num1:(i+1)*num1-1) = Z1(i0:i1,i);
% end;
%     
% 
% num1 = 300;
% tmpX2 = zeros(10*num1);
% tmpZ2 = zeros(10*num1);
% tmpY2 = zeros(10*num1);
% for i=1:length(t)
%     tmpX2(i*num1:(i+1)*num1-1) = X2(i0:i1,i);
%     tmpY2(i*num1:(i+1)*num1-1) = Y2(i0:i1,i);
%     tmpZ2(i*num1:(i+1)*num1-1) = Z2(i0:i1,i);
% end;