%%
%simulation parameters
constants_150710;
numpoints = 2^16;%100e3;
range = 80;%60;%GHz

global pulseBandwidth
pb = linspace(1,12,12)/10;

%%
% clear
% clc
load('fit_avgs_150727');%params from OD measurements
avg=avgs150727;

%pressure broadening
C1 = (avg.gP).*[1,1,1,1,1,.506,...
    .1,.066,.1,.1]; 
% Doppler broadening
C2 = (avg.sD).*[1,1,1,1,1,1,...
    .1,.311,.1,0.7];
% reservoir temperature
C3 = avg.Tr-[2.5,2.5,1.5,-3.0,-6.0,-14.0,...
    -18.75,-22.5,-23,-25];
% pressure shift
C4 = avg.Ps;
% pumping efficiency
C5 = [0.800,0.850,0.900,0.950,0.960,0.930,...
    0.930,0.930,.930,0.930];
% pumping efficiency - GUESSING!
% C5 = [0.800,0.850,0.900,0.950,0.960,0.970,...
%     0.980,0.980,.985,0.990];

t=C3+273.15;w=widths(t,t);
C1_tr = w.gammaP/(2*pi*1e9);
C2_tr = w.sigmaDopp/(2*pi*1e9);
C4_tr = w.shiftP/(2*pi*1e9);



%% parameters for signal scans varying temperature

load('TiSa_scans');
load('TiSa_scans_peaks');

load('151016_errorbars')
C3_U = abs(cal.t_max-cal.t_extr);
C3_L = abs(cal.t_min-cal.t_extr);

C5_U = abs(cal.eta_max-cal.eta_extr);
C5_L = abs(cal.eta_min-cal.eta_extr);

load('ga_finvals');
t1=fin.t;
w1=widths(t1+273.15,t1+273.15);
C1_tr1 = w1.gammaP/(2*pi*1e9);
C2_tr1 = w1.sigmaDopp/(2*pi*1e9);
C3_tr1 = t1;
C4_tr1 = w1.shiftP/(2*pi*1e9);
C5_tr1 = fin.e;



%% fig 3a
% 
% cutoff = 5;
% figure;hold all;
% t=linspace(85,40,10);
% % subplot(4,1,1);plot(C3,C1)
% % ylabel('gamma P')
% % subplot(4,1,2);plot(C3,C2)
% % ylabel('sigma D')
% % subplot(2,1,1);
% errorbar(t(1:cutoff),C5_tr1(1:cutoff),C5_L(1:cutoff),C5_U(1:cutoff),'o')
% plot(t(cutoff+1:10),C5(cutoff+1:10),'rx')
% hold off;
% xlim([35 90]);
% ylim([0.75 1.00])
% ylabel('$w_{Pump}$')
% xlabel('T$_{meas}$ ($^\circ$C)')
% pbaspect([2,1,1])
% % export_fig eta_sole_ebs.pdf -transparent

%% fig 3b
% 
% figure;
% TT = -(-85:0.1:-40);
% numDensDat_man = SteckNumDensity(C3+273.15)*1e-18;
% numDensDat = SteckNumDensity(C3_tr1+273.15)*1e-18;
% numDensU = SteckNumDensity(C3_tr1+C3_U+273.15)*1e-18;
% numDensU = abs(numDensDat-numDensU);
% numDensL = SteckNumDensity(C3_tr1-C3_L+273.15)*1e-18;
% numDensL = abs(numDensDat-numDensL);
% numDensThe = SteckNumDensity(TT+273.15)*1e-18;
% % subplot(2,1,2);
% hold all;
% errorbar(t(1:cutoff),numDensDat(1:cutoff),numDensL(1:cutoff),numDensU(1:cutoff),'o');
% plot(t(cutoff+1:10),numDensDat_man(cutoff+1:10),'rx');
% plot(TT,numDensThe)
% hold off;
% xlim([35 90])
% % ylim([35 90])
% ylabel('n$_{Cs}$ ($10^{18}$m$^{-3}$)')
% xlabel('T$_{meas}$ ($^\circ$C)')
% pbaspect([2,1,1])
% % export_fig num_sole_ebs.pdf -transparent
% 

%%
%%%       t_extr: [80.5907 76.3392 71.8457 67.9491 63.3677 59.8682 55.6840 53.0342 46.2138 45.9445]
%%%     eta_extr: [0.8128 0.8619 0.9055 0.9102 0.9294 0.8615 0.8198 0.6680 0.8720 0.5005]
%%%         t_sd: [0.0569 0.0737 0.0572 0.0708 0.0780 0.1088 0.1120 0.1465 0.2334 0.2242]
%%%       eta_sd: [0.0037 0.0030 0.0031 0.0056 0.0052 0.0069 0.0082 0.0133 0.0179 0.0028]
%%%      eta_ran: [0.0177 0.0164 0.0149 0.0282 0.0284 0.0340 0.0375 0.0645 0.0906 0.0240]
%%%        t_ran: [0.2840 0.3387 0.2960 0.4361 0.4550 0.6225 0.5342 0.6899 1.2284 1.0837]


boolPlot = true;
boolFit = false;
method = 'SA';
boolSave = false;

tOff = 0;%(0:10)*8/10;
etOff = 0;%(0:10)*0.1/10;
bMult = 1.0;%1+(0:10)*1/10;


j=1;
sf = [0.5, 0.5];
bg = [0.52, 0.15];
targ = [6, 14.7];
BoolLoss = [1, 0];%0.5006 unchanged, 0.6646 with vis (doesn't account for bandwidth...)
pb_val = pb([5, 8]);

load('151005_trrfits_paramsAvg')
% sf=cal.sf_avg;
% bg=cal.bg_avg;
numtrials = 1;%;
clearvars f;

clc
        
for i=10
    DatIter = dat.res.(strcat('scan',num2str(i)));
    DatIter.peakLocs = PK.(strcat('scan',num2str(i)));
    
%     tmp = C3(i)-50+273.15; 
%     wt=widths(tmp,tmp);
  
%     if i>cutoff%simanneal fits
%         Pr = C1_tr1(i)-0.5*0.0052227;%bMult*C1(i)-0.5*0.0052227;%wt.gammaP/(2*pi*1e9)-0.5*0.0052227;%
%         Do = C2_tr1(i);%bMult*C2(i);%wt.sigmaDopp/(2*pi*1e9);%
%         Tr = C3_tr1(i);%C3(i);%+tOff;%-10;%
%         Sh = C4_tr1(i);%C4(i);%C4(i);
%         Et = C5_tr1(i);%-etOff;%TRY C5 FOR BETTER STARTING GUESSES...
%     else%manual fits
        Pr = C1(i)-0.5*0.0052227;%bMult*C1(i)-0.5*0.0052227;%%wt.gammaP/(2*pi*1e9)-0.5*0.0052227;%
        Do = C2(i);%bMult*C2(i);%wt.sigmaDopp/(2*pi*1e9);%
        Tr = C3(i);%C3(i);%+tOff;%-10;%
        Sh = C4(i);%C4(i);%C4(i);
        Et = C5(i);%-etOff;%TRY C5 FOR BETTER STARTING GUESSES...
%     end;
    Bg = bg(j);%bg(i);%0.0121;%from average fitting with Tr and eta 151004
    Sf = sf(j);%sf(i);%0.4256;%from average fitting with Tr and eta 151004
    pulseBandwidth = pb_val(j);

    target = targ(j);
    boolAdjLoss = 1;%BoolLoss(j);%true;

    guess = [Pr, Do, Tr, Sh, Et, Sf, Bg, pulseBandwidth];

    for N=1:numtrials
        disp(['stage ',num2str(i),' of 10'])
        disp(['trial ',num2str(N),' of ',num2str(numtrials)])
        
        tic
        f.(['tmp',num2str(i)]).(['trial',num2str(N)]) = ...
            IterFit_align_postOd_ed(...
            DatIter, target, guess, boolPlot,...
            boolFit, method, numpoints, range, boolAdjLoss...
            );
        toc
    end;
    
%         guess = [0, 0, 0-273.15, 0, 0, Sf, Bg, pulseBandwidth];
%      f.NoAtoms = ...
%             IterFit_align_postOd_ed(...
%             DatIter, target, guess, boolPlot,...
%             boolFit, method, numpoints, range, boolAdjLoss...
%             );

end;
if boolSave
    save('151208_SA','f');
end;

