%%
%simulation parameters
constants_150710;
numpoints = 2^16;%100e3;
range = 80;%60;%GHz

global pulseBandwidth
pb = linspace(1,12,12)/10;

%%
% clear
% clc
load('fit_avgs_150727');%params from OD measurements
avg=avgs150727;

%pressure broadening
C1 = (avg.gP).*[1,1,1,1,1,.506,...
    .1,.066,.1,.1]; 
% Doppler broadening
C2 = (avg.sD).*[1,1,1,1,1,1,...
    .1,.311,.1,0.7];
% reservoir temperature
C3 = avg.Tr-[2.5,2.5,1.5,-3.0,-6.0,-14.0,...
    -18.75,-22.5,-23,-25];
% pressure shift
C4 = avg.Ps;
% pumping efficiency
C5 = [0.800,0.850,0.900,0.950,0.960,0.930,...
    0.930,0.930,.930,0.930];
% pumping efficiency - GUESSING!
% C5 = [0.800,0.850,0.900,0.950,0.960,0.970,...
%     0.980,0.980,.985,0.990];

t=C3+273.15;w=widths(t,t);
C1_tr = w.gammaP/(2*pi*1e9);
C2_tr = w.sigmaDopp/(2*pi*1e9);
C4_tr = w.shiftP/(2*pi*1e9);



%% parameters for signal scans varying temperature

load('TiSa_scans');
load('TiSa_scans_peaks');

load('151016_errorbars')
C3_U = abs(cal.t_max-cal.t_extr);
C3_L = abs(cal.t_min-cal.t_extr);

C5_U = abs(cal.eta_max-cal.eta_extr);
C5_L = abs(cal.eta_min-cal.eta_extr);

load('ga_finvals');
t1=fin.t;
w1=widths(t1+273.15,t1+273.15);
C1_tr1 = w1.gammaP/(2*pi*1e9);
C2_tr1 = w1.sigmaDopp/(2*pi*1e9);
C3_tr1 = t1;
C4_tr1 = w1.shiftP/(2*pi*1e9);
C5_tr1 = fin.e;



%%

cutoff = 5;
figure;hold all;
t=linspace(85,40,10);
% subplot(4,1,1);plot(C3,C1)
% ylabel('gamma P')
% subplot(4,1,2);plot(C3,C2)
% ylabel('sigma D')
% subplot(2,1,1);
errorbar(t(1:cutoff),C5_tr1(1:cutoff),C5_L(1:cutoff),C5_U(1:cutoff),'o')
plot(t(cutoff+1:10),C5(cutoff+1:10),'rx')
hold off;
xlim([35 90]);
ylim([0.75 1.00])
ylabel('$w_{Pump}$')
xlabel('T$_{meas}$ ($^\circ$C)')
pbaspect([2,1,1])
% export_fig eta_sole_ebs.pdf -transparent
%%

figure;
TT = -(-85:0.1:-40);
numDensDat_man = SteckNumDensity(C3+273.15)*1e-18;
numDensDat = SteckNumDensity(C3_tr1+273.15)*1e-18;
numDensU = SteckNumDensity(C3_tr1+C3_U+273.15)*1e-18;
numDensU = abs(numDensDat-numDensU);
numDensL = SteckNumDensity(C3_tr1-C3_L+273.15)*1e-18;
numDensL = abs(numDensDat-numDensL);
numDensThe = SteckNumDensity(TT+273.15)*1e-18;
% subplot(2,1,2);
hold all;
errorbar(t(1:cutoff),numDensDat(1:cutoff),numDensL(1:cutoff),numDensU(1:cutoff),'o');
plot(t(cutoff+1:10),numDensDat_man(cutoff+1:10),'rx');
plot(TT,numDensThe)
hold off;
xlim([35 90])
% ylim([35 90])
ylabel('n$_{Cs}$ ($10^{18}$m$^{-3}$)')
xlabel('T$_{meas}$ ($^\circ$C)')
pbaspect([2,1,1])
% export_fig num_sole_ebs.pdf -transparent

