%% Single vib. mode
clear all; close all; clc
%% Parameters
k = 8.617 * 10^-5;   % Boltzman constant
Tph = 25*1e-3;         % Phononic temperature (K)
Te = Tph;            % Electronic temperature (leads)
w0 = 0.007;          % Vibrational frequency (eV)
% g0 = 0.0075;          % Vibrational coupling strength (eV)
gamma = 1.1;
g0 = w0*gamma;          % Vibrational coupling strength (eV)
eps_0 = 0.01;        % Position of the molecular level at zero bias (eV)

lmbd = 0.03/2;        % Background Lambda
wc = 0.003/2;         % Background cut-off energy

yL = 0.0002;         % Left molecule-lead coupling (eV)
yR = 0.0003;         % Right molecule-lead coupling (eV)
Y = (yL + yR)/2;     % Lifetime broadening
betaph = 1/(k*Tph);  % Inverse temperature

Vsd = -0.1:1e-3:0.1; % Bias voltage range
% Vsd = -2:1e-3:2;

bkgd = 0;
% %% Background
% w = linspace(1e-5,1,25000);
% J = (lmbd/2) * (w/wc).^3 .* exp(-w/wc);
% % self.J += (lmbd / 2) * (self.w / wc) ** 3 * np.exp(-self.w / wc)
% bkgd = 1;
% figure(22)
% plot(w,J)
% hold on
% scatter(w0,g0)
%% Phononic correlation function
time=0:2:50000; 
B=zeros(1,numel(time));
for i=1:numel(time)
    t=time(i);
    if bkgd ==1
        C1 = J./(w.^2) .* ( (cos(w.*t)-1) .* coth(betaph.*w/2) - 1i*sin(w.*t));
%     C1 = (self.J)/(self.w**2) * ((np.cos(self.w*t)-1) / np.tanh(betaph*self.w/2) - 1j*np.sin(self.w*t))
        B(i) = exp(trapz(C1,w));
%     self.B[index] = np.exp(np.trapz(C1,self.w)) if self.specden else 1
    end
  
    D1 = (g0/w0)^2 * ( (cos(w0.*t) - 1) .* coth(betaph.*w0./2) - 1i*sin(w0.*t));
    B(i) = exp(D1); %Phononic correlation function
end

% figure(11)
% plot(time,B)
%% Moleucular density of states 
% To evaluate it only once we make use of the shift property of the Fourier
% transform

x = -0.3:5e-5:0.3;
i1 = zeros(1,numel(x));

for j=1:numel(x)
i1(j) = trapz(time,(exp(1i * time * x(j)) .* B .* exp(- Y *time)));
end

i1=real(i1);
i3=fliplr(i1);

figure(5)
plot(x,i1)  %this plots the molecular DOS (should be smooth and integrate to ~pi)


I=zeros(1,numel(Vsd));

for kk=1:numel(Vsd)
bias = Vsd(kk);
%muL =  0.5*bias;
%muR = -0.5*bias;


muL = bias; % left chemical potential; potential applied only to one electrode
muR = 0;    % right chemical potential
eps_M = eps_0 + (0.5) * bias; % we assume that the molecular level shifts with bias


fL=1./(exp((x+eps_M - muL)/(k*Te))+1);
fR=1./(exp((x+eps_M - muR)/(k*Te))+1);

y1L = 1*real(yL/pi * trapz(x,fL.*i1));
y1R = 1*real(yR/pi * trapz(x,fR.*i1));
y3L = 2*real(yL/pi * trapz(x,(1 - fL).*i3));
y3R = 2*real(yR/pi * trapz(x,(1 - fR).*i3));


current = (y1L * y3R - y3L * y1R)/(y1L + y1R + y3L + y3R);
I(kk) = current;

end
%}
I=I*1.602e-3/6.582; % into Amps


figure
hold on
plot(Vsd,I,'-','Linewidth',2)
box on
xlabel('Bias Voltage (V)')
ylabel(' Current (A)')
