load('colmap1.dat','-ascii','colmap1');
load('colmap2.dat','-ascii','colmap2');
load('colmap3.dat','-ascii','colmap3');

colordef white

figures_to_plot = [1:14]; %add figures to the list to plot them. 
% To plot all use
% figures_to_plot = 1:14;
% This will plot the data in Figs. 3, 4, 5, 6, 7, 9, 10, 11, 12 and 13.
% Figs. 1, 2, 8 and 14 are schematics so data is not included.

fprintf(['[\bBy default, this script will plot all 50 panels \n]\b' ...
    '[\bin individual figures. This may take up to a minute.\n]\b'])



if any(figures_to_plot==3)
    %% fig 3A
    f=figure;
    plot_color_fig('fig3A.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',0),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right'); 
    set(f,'Name','Paper Figure 3A')
    movegui('north')
    drawnow;


    %% fig 3B
    f=figure;
    plot_color_fig('fig3B.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',0.14),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3B')
    movegui('north')
    drawnow;

    %% fig 3C
    f=figure;
    plot_color_fig('fig3C.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',0.3),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3C')
    movegui('north')
    drawnow;

    %% fig 3D
    f=figure;
    plot_color_fig('fig3D.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',0.5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3D')
    movegui('north')
    drawnow;

    %% fig 3E
    f=figure;
    plot_color_fig('fig3E.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',0.75),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3E')
    movegui('north')
    drawnow;

    %% fig 3F
    f=figure;
    plot_color_fig('fig3F.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',1),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3F')
    movegui('north')
    drawnow;

    %% fig 3G
    f=figure;
    plot_color_fig('fig3G.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',1.5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3G')
    movegui('north')
    drawnow;

    %% fig 3H
    f=figure;
    plot_color_fig('fig3H.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig3;
    text(0.49,3.45,sprintf('%.2gT',2),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 3H')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==4)
 %% fig 4A
    f=figure;
    plot_color_fig('fig4A.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',2),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4A')
    movegui('north')
    drawnow;
    
 %% fig 4B
    f=figure;
    plot_color_fig('fig4B.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',3),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4B')
    movegui('north')
    drawnow;
    
  %% fig 4C
    f=figure;
    plot_color_fig('fig4C.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',4),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4C')
    movegui('north')
    drawnow;

  %% fig 4D
    f=figure;
    plot_color_fig('fig4D.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4D')
    movegui('north')
    drawnow;


  %% fig 4E
    f=figure;
    plot_color_fig('fig4E.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',6),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4E')
    movegui('north')
    drawnow;

 %% fig 4F
    f=figure;
    plot_color_fig('fig4F.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',7),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4F')
    movegui('north')
    drawnow;

 %% fig 4G
    f=figure;
    plot_color_fig('fig4G.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',8),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4G')
    movegui('north')
    drawnow;

 %% fig 4H
    f=figure;
    plot_color_fig('fig4H.dat',1) %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap1);
    format_fig4;
    text(0.88,6.27,sprintf('%.0fT',9),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    set(f,'Name','Paper Figure 4H')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==5)

    %% fig 5A
    f=figure;
    s=plot_color_fig('fig5A.dat',1); %Plots smoothed intensities
    %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
    %plot_color_fig('fig_1a.dat',1,-1) %Plots errors

    colormap(colmap2);
    xlim([-1 1])
    ylim([2.5 6])
    caxis([0 500])
    a=gca;
    a.PlotBoxAspectRatio=[1.25  1  1.25];
    a.DataAspectRatio=[0.8  1.75     0.8];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='\itl \rm(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.FontSize=14;
    a.XTick=[-1:0.5:1];
    a.YTick=3:6;
    f.Position(3:4)=[632 568];
    s.CData(s.YData>5.2)=2*s.CData(s.YData>5.2);
    hold on;
    ax=axis;
    plot(ax([1 2]),5.2*[1 1],'w--','LineWidth',3)
    set(f,'Name','Paper Figure 5A')
    movegui('north')
    drawnow;

    %% fig 5B
    f=figure;
    s=plot_color_fig('fig5B.dat',0);
    colormap(colmap2);
    xlim([-1 1])
    ylim([2.5 7.5])
    caxis([0 2500])
    a=gca;
    a.PlotBoxAspectRatio=[1  1.1429  1];
    a.DataAspectRatio=[0.8  1.75     0.8];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='\itl \rm(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.FontSize=14;
    a.XTick=[-1:0.5:1];
    a.YTick=3:7;
    f.Position(3:4)=[632 568];
    s.CData(s.YData>5.2)=2*s.CData(s.YData>5.2);
    s.CData(s.YData>6.1)=20*s.CData(s.YData>6.1);
    hold on;
    ax=axis;
    plot(ax([1 2]),5.2*[1 1],'w--','LineWidth',3)
    plot(ax([1 2]),6.1*[1 1],'w--','LineWidth',3)
    data=importdata('fig5B.xy');
    plot(data(:,1),data(:,2),'w-','LineWidth',1.5);
    plot(data(:,1),data(:,3),'w--','LineWidth',1.5);
    plot(data(:,1),data(:,4),'w-','LineWidth',1.5);
    plot(data(:,1),data(:,5),'w--','LineWidth',1.5);
    plot(data(:,1),data(:,6),'w-','LineWidth',1.5);
    [LL,EE]=meshgrid(data(:,1),2:0.1:12);
    EE=EE+LL;
    EE(EE<data(:,6)')=NaN;
    plot(LL',EE','w-','LineWidth',1.5)
    set(f,'Name','Paper Figure 5B')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==6)
    %% fig 6A
    f=figure;
    data=importdata('fig6A.xye',' ',1);
    data=data.data;
    yyaxis left;
    h1=errorbar(data(:,1),data(:,2),data(:,3),'bo','LineWidth',2,'MarkerSize',10,'CapSize',10);
    hold on;
    data2m1=importdata('2m1.xye');
    h2=plot(data2m1(:,1),data2m1(:,2),'b--','LineWidth',2);
    eyeguides=importdata('fig6A.xy');
    plot(eyeguides(:,1),eyeguides(:,2),'b-','LineWidth',2);
    ylim([2.5 6.5])
    ylabel('Energy (meV) at {\itl}=0.5')
    yyaxis right;
    h3=errorbar(data(:,1),data(:,5),data(:,6),'r^','LineWidth',2,'MarkerSize',10,'CapSize',10);
    plot(eyeguides(:,1),eyeguides(:,3),'r-','LineWidth',2)
    ylim([0 60])
    xlim([1 7])
    ylabel('Intensity (arb. units) at {\itl}=0.5')
    xlabel('Field (T)')
    a=gca;
    a.YAxis(1).Color=[0 0 1];
    a.YAxis(2).Color=[1 0 0];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.FontSize=18;
    f.Position(3:4)=[560   420];
    ll=legend([h1 h2 h3],{'m_3 energy', '2m_1 continuum boundary', 'm_3 intensity'},'Location','north','Box','off');
    set(f,'Name','Paper Figure 6A')
    movegui('north')
    drawnow;
    
    %% fig 6B
    f=figure;
    data=importdata('fig6B.xye',' ',1);
    data=data.data;
    yyaxis left;
    h1=errorbar(data(:,1),data(:,2),data(:,3),'bo','LineWidth',2,'MarkerSize',10,'CapSize',10);
    hold on;
    data2m1=importdata('2m1.xye');
    h2=plot(data2m1(:,1),data2m1(:,2),'b--','LineWidth',2);
    eyeguides=importdata('fig6B.xy');
    plot(eyeguides(:,1),eyeguides(:,2),'b-','LineWidth',2)
    ylim([3 5.6])
    ylabel('Energy (meV) at {\itl}=0.5')
    yyaxis right;
    h3=errorbar(data(:,1),data(:,5),data(:,6),'r^','LineWidth',2,'MarkerSize',10,'CapSize',10);
    plot(eyeguides(:,1),eyeguides(:,3),'r-','LineWidth',2)
    ylim([0 50])
    xlim([1 4.5])
    ylabel('Intensity (arb. units) at {\itl}=0.5')
    xlabel('Field (T)')
    a=gca;
    a.YAxis(1).Color=[0 0 1];
    a.YAxis(2).Color=[1 0 0];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.FontSize=18;
    f.Position(3:4)=[560   420];
    ll=legend([h1 h2 h3],{'m_4 energy', '2m_1 continuum boundary', 'm_4 intensity'},'Location','north','Box','off');
    set(f,'Name','Paper Figure 6B')
    movegui('north')
    drawnow;
    
    %% fig 6C
    f=figure;
    data=importdata('fig6C.xye');
    fits=importdata('fig6C.xy',' ',2);
    bkg=eval(fits.textdata{1});
    area(fits.data(:,1),fits.data(:,3),bkg,'FaceColor',[0.3 0.3 0.3],'EdgeColor',[0 0 0],'LineWidth',1.5);
    hold on;
    area(fits.data(:,1),fits.data(:,4),bkg,'FaceColor',[0.7 0.7 0.7],'EdgeColor',[0 0 0],'LineWidth',1.5);
    errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerSize',6,'CapSize',0,'LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    plot(fits.data(:,1),fits.data(:,2),'k-','LineWidth',1.5)
    xlim([1.5 5.5])
    ylim([0 380])
    ax=axis;
    plot(ax([1 2]),bkg*[1 1],'k--','LineWidth',1.5)
    plot(eval(fits.textdata{2})*[1 1],ax([3 4]),'k--','LineWidth',1.5)
    text(5.45,340,sprintf('%.1fT',1.5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    ylabel('Intensity (arb. units)')
    xlabel('Energy (meV)')
    xlim([1.5 5.5])
    ylim([0 380])
    a=gca;
    f.Position(3:4)=[838 338];
    a.PlotBoxAspectRatio=[1      0.38414      0.38414];
    a.FontSize=22;
    a.XTick=1.5:0.5:5.5;
    a.YTick=0:100:300;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    set(f,'Name','Paper Figure 6C')
    movegui('north')
    drawnow;
    
    %% fig 6D
    f=figure;
    data=importdata('fig6D.xye');
    fits=importdata('fig6D.xy',' ',2);
    bkg=eval(fits.textdata{1});
    area(fits.data(:,1),fits.data(:,3),bkg,'FaceColor',[0.3 0.3 0.3],'EdgeColor',[0 0 0],'LineWidth',1.5);
    hold on;
    area(fits.data(:,1),fits.data(:,4),bkg,'FaceColor',[0.7 0.7 0.7],'EdgeColor',[0 0 0],'LineWidth',1.5);
    errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerSize',6,'CapSize',0,'LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    plot(fits.data(:,1),fits.data(:,2),'k-','LineWidth',1.5)
    xlim([1.5 5.5])
    ylim([0 380])
    ax=axis;
    plot(ax([1 2]),bkg*[1 1],'k--','LineWidth',1.5)
    plot(eval(fits.textdata{2})*[1 1],ax([3 4]),'k--','LineWidth',1.5)
    text(5.45,340,sprintf('%.1fT',2.5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    ylabel('Intensity (arb. units)')
    xlabel('Energy (meV)')
    xlim([1.5 5.5])
    ylim([0 380])
    a=gca;
    f.Position(3:4)=[838 338];
    a.PlotBoxAspectRatio=[1      0.38414      0.38414];
    a.FontSize=22;
    a.XTick=1.5:0.5:5.5;
    a.YTick=0:100:300;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    set(f,'Name','Paper Figure 6D')
    movegui('north')
    drawnow;
    
    %% fig 6E
    f=figure;
    data=importdata('fig6E.xye');
    fits=importdata('fig6E.xy',' ',2);
    bkg=eval(fits.textdata{1});
    area(fits.data(:,1),fits.data(:,3),bkg,'FaceColor',[0.3 0.3 0.3],'EdgeColor',[0 0 0],'LineWidth',1.5);
    hold on;
    errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerSize',6,'CapSize',0,'LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    plot(fits.data(:,1),fits.data(:,2),'k-','LineWidth',1.5)
    xlim([1.5 5.5])
    ylim([0 380])
    ax=axis;
    plot(ax([1 2]),bkg*[1 1],'k--','LineWidth',1.5)
    plot(eval(fits.textdata{2})*[1 1],ax([3 4]),'k--','LineWidth',1.5)
    text(5.45,340,sprintf('%.1fT',3.5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    ylabel('Intensity (arb. units)')
    xlabel('Energy (meV)')
    xlim([1.5 5.5])
    ylim([0 380])
    a=gca;
    f.Position(3:4)=[838 338];
    a.PlotBoxAspectRatio=[1      0.38414      0.38414];
    a.FontSize=22;
    a.XTick=1.5:0.5:5.5;
    a.YTick=0:100:300;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    set(f,'Name','Paper Figure 6E')
    movegui('north')
    drawnow;
    
    %% fig 6F
    f=figure;
    data=importdata('fig6F.xye');
    fits=importdata('fig6F.xy',' ',2);
    bkg=eval(fits.textdata{1});
    area(fits.data(:,1),fits.data(:,3),bkg,'FaceColor',[0.3 0.3 0.3],'EdgeColor',[0 0 0],'LineWidth',1.5);
    hold on;
    errorbar(data(:,1),data(:,2),data(:,3),'ko','MarkerSize',6,'CapSize',0,'LineWidth',1.5,'MarkerFaceColor',[1 1 1])
    plot(fits.data(:,1),fits.data(:,2),'k-','LineWidth',1.5)
    xlim([1.5 5.5])
    ylim([0 380])
    ax=axis;
    plot(ax([1 2]),bkg*[1 1],'k--','LineWidth',1.5)
    plot(eval(fits.textdata{2})*[1 1],ax([3 4]),'k--','LineWidth',1.5)
    text(5.45,340,sprintf('%.1fT',4.5),'FontSize',24,'FontName','Arial','FontWeight','Bold','HorizontalAlignment','right');
    ylabel('Intensity (arb. units)')
    xlabel('Energy (meV)')
    xlim([1.5 5.5])
    ylim([0 380])
    a=gca;
    f.Position(3:4)=[838 338];
    a.PlotBoxAspectRatio=[1      0.38414      0.38414];
    a.FontSize=22;
    a.XTick=1.5:0.5:5.5;
    a.YTick=0:100:300;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    set(f,'Name','Paper Figure 6F')
    movegui('north')
    drawnow;


end

if any(figures_to_plot==7)
    %% fig 7A
    f=figure;
    data=importdata('fig7A.xye');
    fits=importdata('fig7A.xy');
    
    h1=plot(fits(:,1),fits(:,2),'b-','LineWidth',2);
    hold on;
    plot(fits(:,1),fits(:,3),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,4),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,5),'b-','LineWidth',2);
    data2m1=importdata('2m1.xye');
    h2=plot(data2m1(:,1),data2m1(:,2),'k--','LineWidth',2);
    h3=errorbar(data(:,1),data(:,14),data(:,15),'*','Color',[0.635 0.078 0.184],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h4=errorbar(data(:,1),data(:,12),data(:,13),'v','Color',[0.301 0.745 0.933],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h5=errorbar(data(:,1),data(:,10),data(:,11),'o','Color',[0.466 0.674 0.188],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h6=errorbar(data(:,1),data(:,8),data(:,9),'^','Color',[0.494 0.184 0.556],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h7=errorbar(data(:,1),data(:,6),data(:,7),'+','Color',[0.929 0.694 0.125],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h8=errorbar(data(:,1),data(:,4),data(:,5),'x','Color',[0.85 0.325 0.098],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h9=errorbar(data(:,1),data(:,2),data(:,3),'s','Color',[0 0.447 0.741],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    ll1=legend([h1, h2, h9, h8, h7, h6, h5, h4, h3],{'High field (\geq 3.5T) fit','2m_1 minimum at {\itl}=0.5','m_1', 'm_2', 'm_3', 'm_4', 'm_5', 'm_6', 'm_7'},'Location','northwest','Box','off');
    ylabel('Band average (meV)')
    xlabel('Field (T)')
    xlim([0 9])
    ylim([1 8])
    a=gca;
    f.Position(3:4)=[560   420];
    a.PlotBoxAspectRatio=[1 0.78917  0.78917];
    a.FontSize=14;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    a.XTick=0:2:8;
    a.YTick=2:2:8;
    set(f,'Name','Paper Figure 7A')
    movegui('north')
    drawnow;
    
    %% fig 7B
    f=figure;
    data=importdata('fig7B.xye');
    fits=importdata('fig7B.xy');
    
    h1=plot(fits(:,1),fits(:,2),'b-','LineWidth',2);
    hold on;
    plot(fits(:,1),fits(:,3),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,4),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,5),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,6),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,7),'b-','LineWidth',2);
    plot(fits(:,1),fits(:,8),'b-','LineWidth',2);
    data2m1=importdata('2m1.xye');
    h2=plot(data2m1(:,1),data2m1(:,2),'k--','LineWidth',2);
    h3=errorbar(data(:,1),data(:,14),data(:,15),'*','Color',[0.635 0.078 0.184],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h4=errorbar(data(:,1),data(:,12),data(:,13),'v','Color',[0.301 0.745 0.933],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h5=errorbar(data(:,1),data(:,10),data(:,11),'o','Color',[0.466 0.674 0.188],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h6=errorbar(data(:,1),data(:,8),data(:,9),'^','Color',[0.494 0.184 0.556],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h7=errorbar(data(:,1),data(:,6),data(:,7),'+','Color',[0.929 0.694 0.125],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h8=errorbar(data(:,1),data(:,4),data(:,5),'x','Color',[0.85 0.325 0.098],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h9=errorbar(data(:,1),data(:,2),data(:,3),'s','Color',[0 0.447 0.741],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    ll1=legend([h1,h2,h9,h8,h7,h6,h5,h4,h3],{'Low field (\leq 1.5T) fit','2m_1 minimum at {\itl}=0.5', 'm_1', 'm_2', 'm_3', 'm_4', 'm_5', 'm_6', 'm_7'},'Location','northwest','Box','off');
    ylabel('Band minimum (meV)')
    xlabel('Field (T)')
    xlim([-0.3 2.1])
    ylim([0.9 5.1])
    a=gca;
    f.Position(3:4)=[560   420];
    a.PlotBoxAspectRatio=[1 0.78917  0.78917];
    a.FontSize=14;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    a.XTick=0:0.5:2;
    a.YTick=1:5;   
    set(f,'Name','Paper Figure 7B')
    movegui('north')
    drawnow;

end

if any(figures_to_plot==9)
    %% fig 9A (adapted from Fig. 3B Ref. [4], R. Coldea et al, Science 327, 177 (2010))
    f=figure;
    plot_color_fig('fig9A_1.dat',1) %plot smoothed intensities
    %plot_color_fig('0T5_2.dat',1,0) %plot raw intensities
    %plot_color_fig('0T5_2.dat',1,-1) %plot errors
    hold on
    plot_color_fig('fig9A_2.dat',1,1,[1 3 -1])
    colormap(colmap2)
    caxis([0 0.4])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    xlim([-1.7 0.3]);
    ylim([0.94 3.25]);
    axis normal;
    a.DataAspectRatio=[0.82136        1.155      0.82136];
    a.PlotBoxAspectRatio=[1.2175            1       1.2175];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    set(gca,'Layer','top')
    a.LineWidth=1.5;
    f.Position(3:4)=[615   477];
    a.YLabel.String='Energy (meV)';
    box on;
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XLabel.String='{\itl} \rm(r.l.u.)';
    title('')
    set(f,'Name','Paper Figure 9A')
    movegui('north')
    drawnow;
    
    %% fig 9B
    f=figure;
    plot_color_fig('fig9B.dat',0)
    colormap(colmap2)
    caxis([0 1])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    xlim([-1.7 0.3]);
    ylim([0.94 3.25]);
    axis normal;
    a.DataAspectRatio=[0.82136        1.155      0.82136];
    a.PlotBoxAspectRatio=[1.2175            1       1.2175];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    set(gca,'Layer','top')
    a.LineWidth=1.5;
    f.Position(3:4)=[615   477];
    a.YLabel.String='Energy (meV)';
    box on;
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XLabel.String='{\itl} \rm(r.l.u.)';
    title('')
    hold on;
    data=importdata('fig9B-D.xye');
    scatter(data(:,1),data(:,2),200,'w.')
    
    set(f,'Name','Paper Figure 9B')
    movegui('north')
    drawnow;
    
    %% fig 9C
    f=figure;
    plot_color_fig('fig9C.dat',0)
    colormap(colmap2)
    caxis([0 1])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    xlim([-1.7 0.3]);
    ylim([0.94 3.25]);
    axis normal;
    a.DataAspectRatio=[0.82136        1.155      0.82136];
    a.PlotBoxAspectRatio=[1.2175            1       1.2175];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    set(gca,'Layer','top')
    a.LineWidth=1.5;
    f.Position(3:4)=[615   477];
    a.YLabel.String='Energy (meV)';
    box on;
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XLabel.String='{\itl} \rm(r.l.u.)';
    title('')
    hold on;
    data=importdata('fig9B-D.xye');
    scatter(data(:,1),data(:,2),200,'w.')
    
    set(f,'Name','Paper Figure 9C')
    movegui('north')
    drawnow;
    
    %% fig 9D
    f=figure;
    plot_color_fig('fig9D.dat',0)
    colormap(colmap2)
    caxis([0 1])
    a=gca;
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    xlim([-1.7 0.3]);
    ylim([0.94 3.25]);
    axis normal;
    a.DataAspectRatio=[0.82136        1.155      0.82136];
    a.PlotBoxAspectRatio=[1.2175            1       1.2175];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    set(gca,'Layer','top')
    a.LineWidth=1.5;
    f.Position(3:4)=[615   477];
    a.YLabel.String='Energy (meV)';
    box on;
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XLabel.String='{\itl} \rm(r.l.u.)';
    title('')
    hold on;
    data=importdata('fig9B-D.xye');
    scatter(data(:,1),data(:,2),200,'w.')
    
    set(f,'Name','Paper Figure 9D')
    movegui('north')
    drawnow;
    
    %% fig 9E
     f=figure;
     s=plot_color_fig('fig9E_lower.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors
    
     colormap(colmap2);
     xlim([-0.61 1.01])
     ylim([2.9 5.9])
     caxis([0 500])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  1.8519 1.014];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(0,-1,{\itl}) \rm(r.l.u.)';
     title('')    
     f2=figure;
     s2=plot_color_fig('fig9E_upper.dat',1);
     s.CData(s.YData>5)=2*s2.CData(s2.YData>5);
     close(f2)
     hold on;
     ax=axis;
     plot(ax([1 2]),5*[1 1],'w--','LineWidth',3)
     set(f,'Name','Paper Figure 9E')
     movegui('north')
     drawnow;
    
     %% fig 9F
     f=figure;
     s=plot_color_fig('fig9F_lower.dat',0);
    
     colormap(colmap2);
     xlim([-0.61 1.01])
     ylim([2.9 5.9])
     caxis([0 2200])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  1.8519 1.014];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
    
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(0,-1,{\itl}) \rm(r.l.u.)';
     title('') 
     
     f2=figure;
     s2=plot_color_fig('fig9F_upper.dat',0);
     
     s.CData(s.YData>5)=2*s2.CData(s2.YData>5);
     close(f2)
     hold on;
     data=importdata('fig9F-H.xy');
     plot(data(:,1),data(:,2),'w-','LineWidth',3)
     plot(data(:,1),data(:,3),'w-','LineWidth',3)
     plot(data(:,1),data(:,4),'w-','LineWidth',3)
     plot(data(:,1),data(:,5),'w-','LineWidth',3)
     ax=axis;
     plot(ax([1 2]),5*[1 1],'w--','LineWidth',3)
     set(gca,'Layer','top')
     set(f,'Name','Paper Figure 9F')
     movegui('north')
     drawnow;
    
      %% fig 9G
     f=figure;
    
     s=plot_color_fig('fig9G_lower.dat',0);
     colormap(colmap2);
     
     xlim([-0.61 1.01])
     ylim([2.9 5.9])
     caxis([0 2200])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  1.8519 1.014];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
    
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(0,-1,{\itl}) \rm(r.l.u.)';
     title('')
    
     
     f2=figure;
     s2=plot_color_fig('fig9G_upper.dat',0);
     
     s.CData(s.YData>5)=2*s2.CData(s2.YData>5);
     close(f2)
     hold on;
     data=importdata('fig9F-H.xy');
     plot(data(:,1),data(:,2),'w-','LineWidth',3)
     plot(data(:,1),data(:,3),'w-','LineWidth',3)
     plot(data(:,1),data(:,4),'w-','LineWidth',3)
     plot(data(:,1),data(:,5),'w-','LineWidth',3)
     ax=axis;
     plot(ax([1 2]),5*[1 1],'w--','LineWidth',3)
     set(gca,'Layer','top')
     set(f,'Name','Paper Figure 9G')
     movegui('north')
     drawnow;
    
    %% fig 9H
     f=figure;
     s=plot_color_fig('fig9H_lower.dat',0);
    
     colormap(colmap2);
     xlim([-0.61 1.01])
     ylim([2.9 5.9])
     caxis([0 2200])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  1.8519 1.014];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
    
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(0,-1,{\itl}) \rm(r.l.u.)';
     title('')
    
     
     f2=figure;
     s2=plot_color_fig('fig9H_upper.dat',0);
     
     s.CData(s.YData>5)=2*s2.CData(s2.YData>5);
     close(f2)
     hold on;
     data=importdata('fig9F-H.xy');
     plot(data(:,1),data(:,2),'w-','LineWidth',3)
     plot(data(:,1),data(:,3),'w-','LineWidth',3)
     plot(data(:,1),data(:,4),'w-','LineWidth',3)
     plot(data(:,1),data(:,5),'w-','LineWidth',3)
     ax=axis;
     plot(ax([1 2]),5*[1 1],'w--','LineWidth',3)
     set(gca,'Layer','top')
     set(f,'Name','Paper Figure 9H')
     movegui('north')
     drawnow;
    
     %% fig 9I
     f=figure;
     s=plot_color_fig('fig9I_lower.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors
    
     colormap(colmap2);
     xlim([-1.35 0.3])
     ylim([0.5 5.5])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  3.0303  0.99558];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(1,0,{\itl}) \rm(r.l.u.)';
     a.XTick=[-1 -0.5 0];
     title('')
     f2=figure;
     s2=plot_color_fig('fig9I_upper.dat',1);
     
     s.CData(s.YData>4.1)=4*s2.CData(s2.YData>4.1);
     close(f2)
     hold on;
     ax=axis;
     plot(ax([1 2]),4.1*[1 1],'w--','LineWidth',3)
     set(f,'Name','Paper Figure 9I')
     movegui('north')
     drawnow;
    
     %% fig 9J
     f=figure;
     s=plot_color_fig('fig9J_lower.dat',0); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors
    
     colormap(colmap2);
     xlim([-1.35 0.3])
     ylim([0.5 5.5])
     caxis([0 5000])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  3.0303  0.99558];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(1,0,{\itl}) \rm(r.l.u.)';
     a.XTick=[-1 -0.5 0];
     title('')
     f2=figure;
     s2=plot_color_fig('fig9J_upper.dat',0);
     s.CData(s.YData>4.1)=4*s2.CData(s2.YData>4.1);
     close(f2)
     hold on;
     ax=axis;
     plot(ax([1 2]),4.1*[1 1],'w--','LineWidth',3)
     data=importdata('fig9J-L.xy');
     plot(data(:,1),data(:,2),'w-','LineWidth',3)
     plot(data(:,1),data(:,3),'w-','LineWidth',3)
     set(f,'Name','Paper Figure 9J')
     movegui('north')
     drawnow;
    
     %% fig 9K
     f=figure;
     s=plot_color_fig('fig9K_lower.dat',0); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors
    
     colormap(colmap2);
     xlim([-1.35 0.3])
     ylim([0.5 5.5])
     caxis([0 5000])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  3.0303  0.99558];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(1,0,{\itl}) \rm(r.l.u.)';
     a.XTick=[-1 -0.5 0];
     title('')
     f2=figure;
     s2=plot_color_fig('fig9K_upper.dat',0);
     s.CData(s.YData>4.1)=4*s2.CData(s2.YData>4.1);
     close(f2)
     hold on;
     ax=axis;
     plot(ax([1 2]),4.1*[1 1],'w--','LineWidth',3)
     data=importdata('fig9J-L.xy');
     plot(data(:,1),data(:,2),'w-','LineWidth',3)
     plot(data(:,1),data(:,3),'w-','LineWidth',3)
     set(f,'Name','Paper Figure 9K')
     movegui('north')
     drawnow;
    
     %% fig 9L
     f=figure;
     s=plot_color_fig('fig9L_lower.dat',0); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors
    
     colormap(colmap2);
     xlim([-1.35 0.3])
     ylim([0.5 5.5])
     caxis([0 5000])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[0.82136  3.0303  0.99558];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     a.YLabel.String='Energy (meV)';
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     a.XLabel.String='(1,0,{\itl}) \rm(r.l.u.)';
     a.XTick=[-1 -0.5 0];
     title('')
     f2=figure;
     s2=plot_color_fig('fig9L_upper.dat',0);
     s.CData(s.YData>4.1)=4*s2.CData(s2.YData>4.1);
     close(f2)
     hold on;
     ax=axis;
     plot(ax([1 2]),4.1*[1 1],'w--','LineWidth',3)
     data=importdata('fig9J-L.xy');
     plot(data(:,1),data(:,2),'w-','LineWidth',3)
     plot(data(:,1),data(:,3),'w-','LineWidth',3)
     set(f,'Name','Paper Figure 9L')
     movegui('north')
     drawnow;

end

if any(figures_to_plot==10)
    %% fig 10
    f=figure;
    data=importdata('fig10.xye');
    plot([0 6],[0 6],'k-','LineWidth',3);
    hold on;
    h1=errorbar(data(data(:,5)==1,4),data(data(:,5)==1,2),data(data(:,5)==1,3),'.','MarkerSize',30,'CapSize',10,'Color',[0 0.447 0.741]);
    h2=errorbar(data(data(:,5)==2,4),data(data(:,5)==2,2),data(data(:,5)==2,3),'.','MarkerSize',30,'CapSize',10,'Color',[0.85 0.325 0.098]);
    h3=errorbar(data(data(:,5)==3,4),data(data(:,5)==3,2),data(data(:,5)==3,3),'.','MarkerSize',30,'CapSize',10,'Color',[0.929 0.694 0.125]);
    h4=errorbar(data(data(:,5)==4,4),data(data(:,5)==4,2),data(data(:,5)==4,3),'.','MarkerSize',30,'CapSize',10,'Color',[0.494 0.184 0.556]);
    h5=errorbar(data(data(:,5)==5,4),data(data(:,5)==5,2),data(data(:,5)==5,3),'.','MarkerSize',30,'CapSize',10,'Color',[0.466 0.674 0.188]);
    h6=errorbar(data(data(:,5)==6,4),data(data(:,5)==6,2),data(data(:,5)==6,3),'.','MarkerSize',30,'CapSize',10,'Color',[0.301 0.745 0.933]);

    ll=legend([h1 h2 h3 h4 h5 h6],{'8T//a m_1'  '8T//a m_2'  '0T m_1'  '0T m_2'  '0T kinetic bound state'  '9T//b'},'Location','northwest','Box','off');
    xlabel('ED calculated energy (meV)')
    ylabel('1D empirical dispersion (meV)')
    a=gca;
     a.PlotBoxAspectRatio=[1 1 1];
     a.DataAspectRatio=[1 1 1];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[560 420];
     box on;
     a.FontSize=16;
    
     set(f,'Name', 'Paper Figure 10')
     movegui('north')
     drawnow;

end

if any(figures_to_plot==11)
    %% fig 11A
    f=figure;
    data=importdata('fig11A.xye');
    calc=importdata('fig11A.xy');
     
    h1=plot(data(:,1),data(:,16),'k--','LineWidth',2);
    hold on
    h2=errorbar(data(:,1),data(:,14),data(:,15),'*','Color',[0.635 0.078 0.184],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h3=errorbar(data(:,1),data(:,12),data(:,13),'v','Color',[0.301 0.745 0.933],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h4=errorbar(data(:,1),data(:,10),data(:,11),'o','Color',[0.466 0.674 0.188],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h5=errorbar(data(:,1),data(:,8),data(:,9),'^','Color',[0.494 0.184 0.556],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h6=errorbar(data(:,1),data(:,6),data(:,7),'+','Color',[0.929 0.694 0.125],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h7=errorbar(data(:,1),data(:,4),data(:,5),'x','Color',[0.85 0.325 0.098],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h8=errorbar(data(:,1),data(:,2),data(:,3),'s','Color',[0 0.447 0.741],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    plot(calc(:,1),calc(:,2),'Color',[0 0.447 0.741],'LineWidth',1.5)
    plot(calc(:,1),calc(:,3),'Color',[0.85 0.325 0.098],'LineWidth',1.5)
    plot(calc(:,1),calc(:,4),'Color',[0.929 0.694 0.125],'LineWidth',1.5)
    plot(calc(:,1),calc(:,5),'Color',[0.494 0.184 0.556],'LineWidth',1.5)
    plot(calc(:,1),calc(:,6),'Color',[0.466 0.674 0.188],'LineWidth',1.5)
    plot(calc(:,1),calc(:,7),'Color',[0.301 0.745 0.933],'LineWidth',1.5)
    plot(calc(:,1),calc(:,8),'Color',[0.635 0.078 0.184],'LineWidth',1.5)
   
    ylabel('Band minimum (meV)')
    xlabel('Field (T)')
    xlim([0 9])
    ylim([1 7])
    a=gca;
    f.Position(3:4)=[560   420];
    a.PlotBoxAspectRatio=[1 0.78917  0.78917];
    a.FontSize=14;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    a.XTick=0:2:8;
    a.YTick=2:2:6;
    
    ll=legend([h1,h2,h3,h4,h5,h6,h7,h8],{'2m_1','m_7','m_6','m_5','m_4','m_3','m_2','m_1'},'Location','northwest','Box','off');
    
    set(f,'Name','Paper Figure 11A')
    movegui('north')
    drawnow;

 %% fig 11B
    f=figure;
    data=importdata('fig11B.xye');
    calc=importdata('fig11B.xy');
    h1=errorbar(data(:,1),data(:,2),data(:,3),'s','Color',[0 0.447 0.741],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    hold on;
    h2=errorbar(data(:,1),data(:,4),data(:,5),'x','Color',[0.85 0.325 0.098],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    h3=errorbar(data(:,1),data(:,6),data(:,7),'+','Color',[0.929 0.694 0.125],'LineWidth',2,'MarkerSize',10,'CapSize',10);
    plot(calc(:,1),calc(:,2),'Color',[0 0.447 0.741],'LineWidth',1.5)
    plot(calc(:,1),calc(:,3),'Color',[0.85 0.325 0.098],'LineWidth',1.5)
    plot(calc(:,1),calc(:,4),'Color',[0.929 0.694 0.125],'LineWidth',1.5)
   
    ylabel('Band maximum (meV)')
    xlabel('Field (T)')
    xlim([2 9])
    ylim([2 6.9])
    a=gca;
    f.Position(3:4)=[560   420];
    a.PlotBoxAspectRatio=[1.2672  1  1];
    a.FontSize=14;
    f.Color=[1 1 1];
    a.LineWidth=1.5;
    a.XTick=0:2:8;
    a.YTick=2:2:6;
    
    ll=legend([h3,h2,h1],{'m_3','m_2','m_1'},'Location','northwest','Box','off');
    
    set(f,'Name','Paper Figure 11B')
    movegui('north')
    drawnow;
    

end


if any(figures_to_plot==12)
    %% fig 12
    f=figure;
    plot_color_fig('fig12.dat',0);
    colormap(colmap3);
    caxis([0 5.3057]);
    hold on;
    data=importdata('fig12.xy');
    scatter(data(:,1),data(:,2),200,'w.')
    xlabel('Field (T) // {\itb}')
    ylabel('Energy (meV)')
    xlim([0 3.4])
    ylim([0.62 3.76])
    a=gca;
    f.Position(3:4)=[615 493];
    a.PlotBoxAspectRatio=[1 1.1 1];
    a.LineWidth=1.5;
    a.FontSize=16;
    a.XTick=0:0.5:3;
    a.YTick=1:0.5:3.5;
    f.Color=[1 1 1];
    set(a,'Layer','top')
    cb=colorbar;
    ylabel(cb,'$S^{xx}(0, \omega)$','Interpreter','latex','Position',[1.5 2.6528 0]);
    cb.YTick=[0 5];

    set(f,'Name','Paper Figure 12')
    movegui('north')
    drawnow;
    
end

if any(figures_to_plot==13)
    %% fig 13A
     f=figure;
     plot_color_fig('fig13A.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors    
     colormap(colmap2);
     data=importdata('fig13A.xy');
     hold on;
     plot(data(:,1),data(:,2),'w-','LineWidth',3);
     plot(data(:,1),data(:,3),'w-','LineWidth',3);
     xlim([-1.3 1.3])
     ylim([2.6 5.5])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     a.DataAspectRatio=[1.0678 1.45  0.82136];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     ylabel('Energy (meV)');
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     xlabel('({\ith},-1,0) \rm(r.l.u.)');
     title('')
     a.XTick=-1:0.5:1;
     a.YTick=3:0.5:5.5;
     set(f,'Name','Paper Figure 13A')
     movegui('north')
     drawnow;

     %% fig 13B
     f=figure;
     plot_color_fig('fig13B.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors    
     colormap(colmap2);
     data=importdata('fig13B.xy');
     hold on;
     plot(data(:,1),data(:,2),'w-','LineWidth',3);
     plot(data(:,1),data(:,3),'w-','LineWidth',3);
     xlim([-0.95 0.8])
     ylim([2.6 5.5])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     ylabel('Energy (meV)');
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     xlabel('(0,{\itk},1) \rm(r.l.u.)');
     title('')
     a.XTick=-1:0.5:1;
     a.YTick=3:0.5:5.5;
     set(f,'Name','Paper Figure 13B')
     movegui('north')
     drawnow;

    %% fig 13C
     f=figure;
     data=importdata('fig13C.xye');
     h1=errorbar(data(data(:,6)==1,7),data(data(:,6)==1,4),data(data(:,6)==1,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.5451 0 0.5451]);
     hold on;
     h2=errorbar(data(data(:,6)==2,7),data(data(:,6)==2,4),data(data(:,6)==2,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.7451 0.7451 0.7451]);

     plot([2 6],[2 6],'k-','LineWidth',3);
     xlim([3 5])
     ylim([3 5])

     ll=legend([h2 h1],{'E_+' 'E_-'},'Location','northwest','Box','off');
     xlabel('Calculated energy (meV)')
     ylabel('Observed energy (meV)')
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615 477];
     box on;
     a.FontSize=22;

     set(f,'Name', 'Paper Figure 13C')
     movegui('north')
     drawnow;

     %% fig 13D
     f=figure;
     plot_color_fig('fig13D.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors    
     colormap(colmap2);
     data=importdata('fig13D.xy');
     hold on;
     plot(data(:,1),data(:,2),'w-','LineWidth',3);
     plot(data(:,1),data(:,3),'w-','LineWidth',3);
     xlim([0.35 1.65])
     ylim([0.75 1.05])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     ylabel('Energy (meV)');
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     xlabel('({\ith},0,0) \rm(r.l.u.)');
     title('')
     a.XTick=-1:0.5:1;
     a.YTick=0.8:0.1:1;
     set(f,'Name','Paper Figure 13D')
     movegui('north')
     drawnow;

   %% fig 13E
     f=figure;
     plot_color_fig('fig13E.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors    
     colormap(colmap2);
     data=importdata('fig13E.xy');
     hold on;
     plot(data(:,1),data(:,2),'w-','LineWidth',3);
     plot(data(:,1),data(:,3),'w-','LineWidth',3);
     cb=colorbar;
     ylabel(cb,'Intensity (arb. units)')
     cb.YTick=[0 800];
     xlim([-0.25 0.25])
     ylim([0.75 1.05])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     ylabel('Energy (meV)');
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     xlabel('(1,{\itk},0) \rm(r.l.u.)');
     title('')
     a.XTick=-0.2:0.1:0.2;
     a.YTick=0.8:0.1:1;
     set(f,'Name','Paper Figure 13E')
     movegui('north')
     drawnow;

      %% fig 13F
     f=figure;
     data=importdata('fig13F.xye');
     h1=errorbar(data(data(:,6)==1,7),data(data(:,6)==1,4),data(data(:,6)==1,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.5451 0 0.5451]);
     hold on;
     h2=errorbar(data(data(:,6)==2,7),data(data(:,6)==2,4),data(data(:,6)==2,5),'.','MarkerSize',20,'CapSize',6,'Color',[0.7451 0.7451 0.7451]);
     h3=errorbar(data(data(:,6)==3,7),data(data(:,6)==3,4),data(data(:,6)==3,5),'.','MarkerSize',20,'CapSize',6,'Color',[0 0.3 0]);

     plot([0 6],[0 6],'k-','LineWidth',3);
     xlim([0.7 4])
     ylim([0.7 4])

     ll=legend([h3 h2 h1],{'\omega_3','\omega_2','\omega_1'},'Location','northwest','Box','off');
     xlabel('Calculated energy (meV)')
     ylabel('Observed energy (meV)')
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615 477];
     box on;
     a.FontSize=22;
     a.XTick=1:1:4;
     a.YTick=1:0.5:4;
    
     set(f,'Name', 'Paper Figure 13F')
     movegui('north')
     drawnow;

    %% fig 13G
     f=figure;
     plot_color_fig('fig13G.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors    
     colormap(colmap2);
     data=importdata('fig13G.xy');
     hold on;
     plot(data(:,1),data(:,2),'w-','LineWidth',3);
     xlim([-0.6 2.4])
     ylim([3.25 4.1])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     ylabel('Energy (meV)');
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     xlabel('({\ith},0,-1) \rm(r.l.u.)');
     title('')
     a.XTick=0:1:2;
     a.YTick=3.4:0.2:4;
     set(f,'Name','Paper Figure 13G')
     movegui('north')
     drawnow;

     %% fig 13H
     f=figure;
     plot_color_fig('fig13H.dat',1); %Plots smoothed intensities
     %plot_color_fig('fig_1a.dat',1,0) %Plots raw intensities
     %plot_color_fig('fig_1a.dat',1,-1) %Plots errors    
     colormap(colmap2);
     data=importdata('fig13H.xy');
     hold on;
     plot(data(:,1),data(:,2),'w-','LineWidth',3);
     xlim([-0.45 0.45])
     ylim([3.25 4.1])
     caxis([0 800])
     a=gca;
     a.PlotBoxAspectRatio=[1.2175  1  1.2175];
     f.Color=[1 1 1];
     a.Color=[1 1 1];
     a.XAxis.Color=[0 0 0];
     a.YAxis.Color=[0 0 0];
     set(gca,'Layer','top')
     a.LineWidth=1.5;
     f.Position(3:4)=[615   477];
     ylabel('Energy (meV)');
     box on;
     a.FontSize=22;
     a.YLabel.FontSize=24;
     a.XLabel.FontSize=24;
     xlabel('(1,{\itk},-1) \rm(r.l.u.)');
     title('')
     a.XTick=-0.4:0.2:0.4;
     a.YTick=3.4:0.2:4;
     set(f,'Name','Paper Figure 13H')
     movegui('north')
     drawnow;
    

end



%% Subroutines to plot
function hout=plot_color_fig(fdata,isErr,flag,xscale)
% Plots color data in .dat file, with isErr specifying if the input
% .dat file contains a column for errors (i.e. if experimental data); and
% flag specifying whether to plot smoothed intensities (flag=1 - default),
% raw intensities (flag=0), or errors (flag=-1).
% Additionally evaluates code strings specified as optional arguments.
% xscale =[p f side=+/-] is an optional scale factor for the xwidth of column number
% p on the + or - side=+/-1 (p = integer between 1 and size(X,2) number of columns) 
% this can be of the form [p1 f1 s1; p2 f2 s2;...] 
    
    fdata=importdata(fdata,' ',1);
    
    sz=eval(fdata.textdata{1});
    
    if ~exist('flag','var') %By default, set flag to 1
        flag=1;
    end
    
    % Reshape to 2D array for plotting
    if isErr
    X=reshape(fdata.data(:,1),sz);
    Y=reshape(fdata.data(:,end-3),sz);
    switch flag
        case -1 %Plot errors
            C=reshape(fdata.data(:,end-1),sz);
        case 0 %Raw intensities
            C=reshape(fdata.data(:,end-2),sz);
        case 1 %Smoothed intensities
            C=reshape(fdata.data(:,end),sz);
    end
    else
    X=reshape(fdata.data(:,1),sz);
    Y=reshape(fdata.data(:,end-1),sz);
    C=reshape(fdata.data(:,end),sz);    
    end
    
    % from (X,Y) bin centers construct arrays of bin edges (Xb,Yb) 
% X,Y,C(n,m)  Xb,Yb,Cb(n+1,m+1)
[Xb,Yb,Cb]=cen2edge(X,Y,C);  

if exist('xscale','var')&&~isempty(xscale)&&isnumeric(xscale)&&(size(xscale,2)==3)&&(all(xscale(:,1))<=size(X,2))
    [~,perm]=sort(xscale(:,1));
    xscale=xscale(perm,:);
    for i=1:size(xscale,1)
        j=xscale(i,1);
        xwidth=Xb(:,j+1)-Xb(:,j);
        cen=(Xb(:,j+1)+Xb(:,j))/2;
        switch xscale(i,3)
            case {-1}, Xb(:,j)=cen-xwidth/2*xscale(i,2);
            case {+1}, Xb(:,j+1)=cen+xwidth/2*xscale(i,2);
            otherwise
                fprintf(2,'xscale=[p f s]; s expected to be -/+1 for left/right side of boundary to be scaled\n');
                hout=[];
                return
        end
    end
end
h=pcolor(Xb,Yb,Cb);
shading flat

isNum=~isnan(Cb);
axis([min(Xb(isNum)) max(Xb(isNum)) min(Yb(isNum)) max(Yb(isNum))])

if nargout>0
    hout=h;
end
end

function [xb,yb,zz]=cen2edge(x,y,z)
xx=(x(:,1:(end-1))+x(:,2:end))/2;
x1=x(:,1)-(-x(:,1)+xx(:,1));
xn=x(:,end)+(x(:,end)-xx(:,end));
xb=[x1 xx xn];
xb(end+1,:)=xb(end,:);
yy=(y(1:(end-1),:)+y(2:end,:))/2;
y1=y(1,:)-(-y(1,:)+yy(1,:));
yn=y(end,:)+(y(end,:)-yy(end,:));
yb=[y1;yy;yn];
yb(:,end+1)=yb(:,end);
zz=z;
zz(end+1,:)=NaN;
zz(:,end+1)=NaN;
end

function format_fig3
    xlim([-0.5 0.5]);
    ylim([1.1 3.55]);
    caxis([0 250]);
    cb=colorbar;
    a=gca;
    a.PlotBoxAspectRatio=[1.1378 1 1.1606];
    f=gcf;
    f.Position(3:4)=[598   518];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='\itl \rm(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.LineWidth=1.5;
    cb.Color=[0 0 0];
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XTick=-0.4:0.2:0.4; %for Ei=4.3
    set(gca,'Layer','top')
end

function format_fig4
    xlim([-0.9 0.9]);
    ylim([1.4 6.5]);
    caxis([0 250]);
    cb=colorbar;
    a=gca;
    a.PlotBoxAspectRatio=[1.1328 1 1.158];
    f=gcf;
    f.Position(3:4)=[598   518];
    f.Color=[1 1 1];
    a.Color=[1 1 1];
    a.XAxis.Color=[0 0 0];
    a.YAxis.Color=[0 0 0];
    a.XLabel.String='\itl \rm(r.l.u.)';
    a.YLabel.String='Energy (meV)';
    a.LineWidth=1.5;
    cb.Color=[0 0 0];
    a.FontSize=22;
    a.YLabel.FontSize=24;
    a.XLabel.FontSize=24;
    a.XTick=[-0.5 0 0.5]; %for Ei=4.3
    set(gca,'Layer','top')
end


