;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Functions to track progress and write output to file

(defun initial-zero (number)
    (let ((initstring (write-to-string number)))
        (if (= (length initstring) 1)
            (concatenate 'string "0" initstring)
            initstring)))

(defun timestamp ()
    (multiple-value-bind (sec min hour day mon year)
                     (get-decoded-time)
                     (concatenate 'string (initial-zero year) "-"
                                          (initial-zero mon) "-"
                                          (initial-zero day) "_"
                                          (initial-zero hour) "-"
                                          (initial-zero min) "-"
                                          (initial-zero sec))))

(defun datestamp ()
    (multiple-value-bind (sec min hour day mon year)
                     (get-decoded-time)
                     (declare (ignore sec min hour))
                     (concatenate 'string (initial-zero year) "-"
                                          (initial-zero mon) "-"
                                          (initial-zero day))))


(defun timepoint-with-index (timepoint index)
        (concatenate 'string timepoint "-" (initial-zero index)))

(defun create-output-directory (datestamp timepoint)
   (let ((thisdir (concatenate 'string "[ABSOLUTE PATH TO MODULE]/Outputs/" datestamp "/" timepoint)))
       (run-program "mkdir" (list thisdir))
       thisdir))

(defun outputpath (thisdir timepoint extension)
        (make-pathname :name timepoint
                   :type extension
                   :directory thisdir
                   :defaults "[ABSOLUTE PATH TO MODULE]/init.lisp"))

(defun outputpath-with-index (thisdir timepoint index extension)
       (make-pathname :name (timepoint-with-index timepoint index)
                  :type extension
                  :directory thisdir
                  :defaults "[ABSOLUTE PATH TO MODULE]/init.lisp"))


(defvar *run-directory*)
(defvar *outputfile-graph*)
(defvar *outputfile*)

(defun new-output-file (directory timepoint extension)
    (setf *outputfile* (outputpath directory timepoint extension)))

(defun new-output-graphfile (directory timepoint)
    (setf *outputfile-graph* (outputpath directory timepoint "gv")))

(defun new-output-graphfile-with-index (directory timepoint index)
    (setf *outputfile-graph* (outputpath-with-index directory timepoint index "gv")))

(defun new-output-file-set (directory timepoint)
    (new-output-file directory timepoint "csv")
    (new-output-graphfile directory timepoint))
