;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Code developed after analysis of, and drawing on the content of, ACT-R code
;;; published by Lewis & Vasishth 2005 and Engelmann 2016
;;; https://github.com/felixengelmann/act-r-sentence-parser-em

(chunk-type parse goal-state locus lddopen lddtype ldd holdid1 holdid2 holdid3 holdid4)

(chunk-type lex-ent string
            cat ma ma.cat
            pre.ma.cat pre.ma.gf
            post.ma.cat post.ma.gf
            subcat rel
            predreqd pred
            subj obj obl obj-th comp adj
            ggf1 ggf2 ggf3 valency
            ggf1.stat ggf2.stat ggf3.stat
            gf.prec gf.post1 gf.post2
            pcase comp-poss
            adj.prec adj.prec.cat
            adj.post adj.post.cat)

(chunk-type f-rep cat rel ma deps
            ma.cat
            pre.ma.cat pre.ma.gf
            post.ma.cat post.ma.gf
            ldd predreqd pred
            df
            ggf1 ggf1.stat
            ggf2 ggf2.stat
            ggf3 ggf3.stat
            gf.prec gf.post1 gf.post2
            subj obj obl obj-th comp adj
            adj.prec adj.prec.cat
            adj.post adj.post.cat
            dep1 dep1.gf
            dep2 dep2.gf
            dep3 dep3.gf
            dep4 dep4.gf
            pcase comp-poss compform
            embedded)

(chunk-type syntpro pred)

(sgp  ; sets parameters for the various ACT-R modules

      :esc t                ;
      :lf .05               ;
      :trace-detail low     ;
      :rt -0.5              ; Retrieval threshold
      :ans 0.05              ; Activation noise
      :mas 10               ; enable spreading activation - number OK?
      :vp-activation 2.0    ; VP buffer has spreading activation
      :bll 0.5              ;
      :show-focus t         ; shows on the window where the focus is

;     PROCEDURAL module
;      :cycle-hook production-path-increment
      :er t ; random resolution if more than one production is possible

;     UTILITY module
      :ul t                 ; t = learn utilities as the model runs
 ;     :ult t                ; t = show utility learning on the trace


;      ; PRODUCTION-COMPILATION module
;      :epl t                ; enables compilation
;      :pct t                ; shows production compilation trace

      ; IMAGINAL module
      :imaginal-delay 0.2  ; Time to create a chunk in seconds (default 0.2)


      )
;;; PRINTING MODULE - this prints the output to a file with path in *outputfile* - see timestamp.lisp
;(sgp-fct (list :v *outputfile* ))

(setf *create-interim-graphs* t) ; if InterimGraph is t, a graph of chunks will be produced after each word


(define-chunks

;;;GOAL CHUNK VALUES
  (goal isa parse lddopen no lddtype no ldd no holdid1 no holdid2 no goal-state start locus t)

;;;GOAL CHUNK GOAL-STATE SLOT VALUES
  (start isa chunk) (find isa chunk)
  (attend isa chunk) (lookup isa chunk)
  (connect isa chunk) (assess isa chunk)
  (create isa chunk) (adapt isa chunk)
  (relpro1 isa chunk) (check-ldd isa chunk)
  (relpro2 isa chunk) (rrc isa chunk) (rrc1 isa chunk)
  (break isa chunk) (setup-vcomp isa chunk)
  (setup-ncomp isa chunk)
;  (attach-down isa chunk) (seekmother isa chunk)
;  (attach-up isa chunk) (ldd-trial-detach isa chunk)
;  (ldd-trial-cancel isa chunk) (ldd-trial-attach isa chunk)
;  (next-target isa chunk)
  (finish isa chunk) (find-f isa chunk)
  (attach isa chunk) (assign isa chunk)
  (compare isa chunk) (checknoun isa chunk)
  (checkclauseend isa chunk) (wrapup isa chunk)
  (add-gfs isa chunk) (expand-deps isa chunk)
;  (ldd isa chunk) (add-to-f isa chunk)
;  (find-host isa chunk) (connect-to-host isa chunk)

;;;GOAL CHUNK LOCUS SLOT VALUES
  (np isa chunk)  (vp isa chunk) (ap isa chunk)

;;;CAT SLOT VALUES
  (Noun isa chunk) (Pron isa chunk)
  (Verb isa chunk) (Det isa chunk)
  (Prep isa chunk) (Catcomp isa chunk)
;;; (Adjcv isa chunk) (Adv isa chunk)

;;;NUM FEATURE VALUES
;;; (sg isa chunk) (pl isa chunk)

;;;GEN FEATURE VALUES
;;; (masc isa chunk) (fem isa chunk)
;;; (neut isa chunk)

;;;GF FEATURE VALUES
  (plus isa chunk) (minus isa chunk)
  (o isa chunk) (r isa chunk)
  (c isa chunk) (g isa chunk)

;;;FEATURE VALUES
  (yes isa chunk) (no isa chunk)
  (maybe isa chunk)

;;;LDD STATUS VALUES
  (open isa chunk) (prov isa chunk)

;;;PERS FEATURE VALUES
;;; (one isa chunk) (two isa chunk)
;;; (three isa chunk)

;;;CASE FEATURE VALUES
;;;(nom isa chunk) (nonnom isa chunk)

;;;SUBCAT SLOT VALUES
  (common isa chunk) (trans isa chunk)
  (introbl isa chunk) (transobl isa chunk)
  (qn isa chunk) (dem isa chunk)
;;; (article isa chunk) (possessive isa chunk)
 (personal isa chunk) (proper isa chunk)
;;; (time isa chunk) (degree isa chunk)

;;;DEF SLOT VALUES
  (indef isa chunk) (def isa chunk)

;;;PRED VALUES
  (pro isa syntpro pred "PRO")
  (pro_1 isa syntpro pred "PRO_1")
  (pro_2 isa syntpro pred "PRO_2")
  (pro_3 isa syntpro pred "PRO_3")
  (pro_4 isa syntpro pred "PRO_4")
  (pro_5 isa syntpro pred "PRO_5")
  (pro_6 isa syntpro pred "PRO_6")
  (pro_7 isa syntpro pred "PRO_7")
  (pro_8 isa syntpro pred "PRO_8")
  (pro_9 isa syntpro pred "PRO_9")
  (pro_10 isa syntpro pred "PRO_10")

;;;ARGUMENT STRUCTURE VALUES
  (reqd isa chunk) (poss isa chunk)
  (alt isa chunk) (orpro isa chunk)

;;;PCASE VALUES
  (for isa chunk) (to isa chunk)

;;;TENSE FEATURE VALUES
;;; (past isa chunk)

;;;F-REP TYPE VALUES
  (n isa chunk) (v isa chunk)
  (p isa chunk) (adv isa chunk)
  (adjcv isa chunk) (relpro isa chunk)
  (d isa chunk)

;;;F-REP HOSTGF VALUES
  (subj isa chunk) (obj isa chunk)
  (obl isa chunk) (adj isa chunk)
  (obj-th isa chunk) (comp isa chunk)
  (v-pred isa chunk) (df isa chunk)
  (loc isa chunk)
  (ggf1 isa chunk) (ggf2 isa chunk) (ggf3 isa chunk)
  (dep1 isa chunk) (dep2 isa chunk) (dep3 isa chunk) (dep4 isa chunk)
  (dep1.gf isa chunk) (dep2.gf isa chunk) (dep3.gf isa chunk) (dep4.gf isa chunk)
)

(defvar *subj* '((o minus) (r minus) (g plus)))
(defvar *obj* '((o plus) (r minus) (c minus) (g plus)))
(defvar *obj-th* '((o plus) (r plus) (c minus) (g plus)))
(defvar *obl* '((o minus) (r plus) (c minus) (g plus)))
(defvar *comp* '((o plus) (r minus) (c plus) (g plus)))
(defvar *xcomp* '((o plus) (r plus) (c plus) (g plus)))
(defvar *adj* '((g minus)))
(defvar *ugflist* (list (list 'subj *subj*) (list 'obj *obj*) (list 'obj-th *obj-th*)
                        (list 'obl *obl*) (list 'comp *comp*) (list 'xcomp *xcomp*)))
(defvar *noun* '((adjcv minus) (adv minus) (n plus) (p minus) (v minus)))
(defvar *prep* '((adjcv minus) (adv minus) (n minus) (p plus) (v minus)))
(defvar *bigprolist* '(pro_1 pro_2 pro_3 pro_4 pro_5 pro_6 pro_7 pro_8 pro_9 pro_10))
(defvar *smallprolist* (list "pro_i" "pro_j" "pro_k" "pro_l" "pro_m" "pro_n"))

(defvar *bigpro*)
(defvar *smallpro*)


;  )
