;;; This work is licensed under the Creative Commons
;;; Attribution-NonCommercial-ShareAlike 4.0 International License.
;;; To view a copy of this license, visit
;;; http://creativecommons.org/licenses/by-nc-sa/4.0/ or send a letter to
;;; Creative Commons, PO Box 1866, Mountain View, CA 94042, USA.

;;; Code developed after analysis of, and drawing on the content of, ACT-R code
;;; published by Lewis & Vasishth 2005 and Engelmann 2016
;;; https://github.com/felixengelmann/act-r-sentence-parser-em

;;; Procedural memory for lfgmodel.lisp
;;; These productions read text from the screen and make individual words
;;; available to the parser. They also control the beginning and end of a parse.
;;; INITIALISE - moves VISUAL-LOCATION to the position of the leftmost word
;;; FIND-NEXT-WORD - moves VISUAL-LOCATION position one word to the right
;;;       [currently no moving between lines]
;;; ATTEND-WORD - places the text at VISUAL-LOCATION in the VISUAL BUFFER

(p initialise
  =goal>
    isa   parse
    goal-state start      ; Only ever appears in the initial goal
;  ?attach>
;    state free
  ==>
;  !safe-eval! (command-output "=========")
  !safe-eval! (setf *index* 0)
  !safe-eval! (setf *cycle-start* (mp-time-ms))
  !safe-eval! (setf *this-word* "")
  !safe-eval! (new-output-graphfile-with-index *run-directory* *run-index-time* *run-index*)
  !safe-eval! (setf *smallpro* *smallprolist*)
  !safe-eval! (setf *bigpro* *bigprolist*)
  !safe-eval! (setf *f-rep-chunks* ()) ; reset the chunk list
  =goal>
    goal-state attend     ; Change state to allow text to be recognised
;    target-gf subj          ; Predict a subject as the next grammatical function
;  +attach>                ; Put a blank chunk into the ATTACH buffer
;    pred      reqd
  +visual-location>         ; Find word at top left of text
    screen-x  lowest
    screen-y  highest
  )


(p find-next-word
    !eval! (istrue) ; this is to stop the production compiling which leads to odd loops
    =goal>
      isa    parse
      goal-state  find
;    ?imaginal>              ; Confirm IMAGINAL has created a chunk
;      state  free
    ==>
    !safe-eval! (setf *cycle-time* (- (mp-time-ms) *cycle-start*))
    !safe-eval! (interim-graph *create-interim-graphs* *run-directory* *run-index-time* *run-index* *index* *f-rep-chunks*)
;    !safe-eval! (setf *path-length* (list-length *production-path*))
;    !safe-eval! (update-message-attached *index* *this-word* *path-length* *cycle-time* (- *cycle-time* (* 50 *path-length*)) *refcode*)
    !safe-eval! (setf *cycle-start* (mp-time-ms))
    !safe-eval! (update-message-csv1 *outputfile* *run-index-time* *run-index* *sent-ref* *index* *this-word* *cycle-time*)
    !safe-eval! (setf *index* (+ *index* 1))
;    !safe-eval! (setf *production-path* ())
;    !safe-eval! (setf *retrieval-time* ( - *lex-retrieval-end* *lex-retrieval-start* ))
;    !safe-eval!
;            (if (= *attachment-end* 0)
;                  (setf *attach-time* (- (mp-time-ms) *attachment-start*))
;                  (setf *attach-time* (- *attachment-end* *attachment-start*))
;            )
;    !safe-eval! (update-message-timings *index* *this-word* *retrieval-time* *attach-time*)
;    !safe-eval! (setf *attachment-end* 0)
;
    =goal>
      goal-state attend
;    -imaginal>              ; Release IMAGINAL chunk - use in Dummy Run
    +visual-location>       ; Move to word on the right
    :attended nil
  > screen-x  current
    screen-x  lowest
  )

;attend to next word

(p attend-word
    =goal>
      isa     parse
      goal-state   attend
    =visual-location>
    ?visual>
      state   free
    ==>
;    !safe-eval! (setf *index* (+ *index* 1))
    =goal>
      goal-state   lookup
    +visual>                          ; Place text from word into VISUAL buffer
      isa     move-attention
      screen-pos  =visual-location
  )



(p prosodic-break
    =goal>
      isa    parse
      goal-state  lookup
    =visual>
      isa    text
      value  "||"
    ==>
    =goal>
      goal-state break
    =visual>
)
;end if next word is '*'

(p text-end-wrapup
    =goal>
      isa    parse
      goal-state  lookup
    =visual>
      isa    text
      value  "*"
    ==>
    =goal>
      goal-state wrapup
    =visual>
)

(p end-parse
    =goal>
     goal-state finish
    ==>
    =goal>
     goal-state nil
    -imaginal>
    -np>
    -vp>
    !safe-eval! (clear-multibuffer-to-dm 'vp)
    !safe-eval! (sgp-fct (list :v t :cmdt t))
    !safe-eval! (generate-graph *f-rep-chunks* *outputfile-graph*)
  )
